/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates.ui;

import com.paterva.maltego.certificates.ui.view.CertificateCallback;
import com.paterva.maltego.certificates.ui.view.CertificateDownloader;
import com.paterva.maltego.certificates.ui.view.CertificateTabbedView;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.components.PanelWithMatteBorderAllSides;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import javax.swing.JComponent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

public class CertificateDisplayer {
    public static void showCertificate(JComponent parent, HubSeedDescriptor seed, String hubSeedUrl) {
        if (hubSeedUrl != null) {
            CertificateDisplayer.showCertificate(parent, seed.getDisplayName(), hubSeedUrl);
        }
    }

    public static void showCertificate(final JComponent parent, final String seedName, String seedUrl) {
        try {
            WindowUtil.showWaitCursor((JComponent)parent);
            CertificateDownloader certDownloader = new CertificateDownloader();
            URL url = new URL(seedUrl);
            certDownloader.get(url, new CertificateCallback(){

                @Override
                public void onCertificate(X509Certificate cert) {
                    CertificateDisplayer.showCertificate(parent, seedName, cert);
                }

                @Override
                public void onCertificateMissingOrInvalid(String msg) {
                    String title = seedName;
                    if (StringUtilities.isNullOrEmpty((String)msg)) {
                        msg = "No valid certificate could be found. If you are using your own hub item with a self-signed certificate, please first add your certificate to the Maltego trusted certificates from the \"Certificate Manager\" item under the \"Transforms\" ribbon tab.";
                        title = title + " Certificate Invalid Or Missing";
                    }
                    CertificateDisplayer.showCertificateMessage(parent, title, msg);
                }
            });
        }
        catch (MalformedURLException ex) {
            WindowUtil.hideWaitCursor((JComponent)parent);
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void showCertificate(JComponent parent, String seedName, X509Certificate cert) {
        WindowUtil.hideWaitCursor((JComponent)parent);
        if (cert != null) {
            PanelWithMatteBorderAllSides panel = new PanelWithMatteBorderAllSides((LayoutManager)new BorderLayout());
            panel.add(new CertificateTabbedView(cert, "A summary of the certificate information is shown below, with more detailed information shown on the \"Details\" tab."));
            DialogDescriptor dd = new DialogDescriptor((Object)panel, seedName + " Certificate");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        }
    }

    public static void showCertificateMessage(JComponent parent, String title, String message) {
        WindowUtil.hideWaitCursor((JComponent)parent);
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message);
        nd.setTitle(title);
        nd.setMessageType(2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
    }
}

