/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api;

import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.transform.runner.api.TransformDoneMutex;
import com.paterva.maltego.transform.runner.api.TransformRunException;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.NormalException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public abstract class AsyncTransformRunner {
    private static final Logger LOG = Logger.getLogger(AsyncTransformRunner.class.getName());
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Async Transform Runner", 10, true);
    private static final long MILLIS_BETWEEN_CHECKS = TimeUnit.MINUTES.toMillis(5L);
    private static long lastLicenseCheck = 0L;

    protected abstract void runTransform() throws Exception;

    public Cancellable run(TransformDoneMutex doneMutex) {
        Args.notNull((Object)doneMutex, (String)"doneMutex");
        Runnable runnable = () -> {
            try {
                this.doTransform();
            }
            catch (Exception ex) {
                String msg = ex.getMessage();
                if (msg != null && (msg.contains("timed out") || msg.contains("No response received"))) {
                    LOG.warning(msg);
                } else {
                    NormalException.logStackTrace((Throwable)ex);
                }
            }
            finally {
                TransformDoneMutex transformDoneMutex = doneMutex;
                synchronized (transformDoneMutex) {
                    doneMutex.notify();
                }
            }
        };
        return PROCESSOR.post(runnable);
    }

    private void doTransform() throws TransformRunException {
        if (!this.validateLicense()) {
            throw new TransformRunException("Maltego needs to be activated before it can run transforms (alternatively please check your network and proxy settings).");
        }
        try {
            this.runTransform();
        }
        catch (Exception ex) {
            if (ex instanceof TransformRunException) {
                throw (TransformRunException)ex;
            }
            throw new TransformRunException(ex);
        }
    }

    private boolean validateLicense() {
        long time = System.currentTimeMillis();
        long delta = time - lastLicenseCheck;
        if (delta > MILLIS_BETWEEN_CHECKS) {
            lastLicenseCheck = time;
            return LicenseManager.A().A(false, true);
        }
        return true;
    }
}

