/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.runner.api.TransformRunOrigin;
import com.paterva.maltego.transform.runner.api.TransformsRunContext;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.FastURL;
import java.util.Map;
import java.util.Optional;

public class TransformRunnerContext {
    private final TransformsRunContext transformsContext;
    private final Map<EntityID, MaltegoEntity> inputEntities;
    private final Map<MaltegoLink, LinkEntityIDs> inputLinks;
    private final TransformDefinition transform;
    private final DataSource transformInputs;
    private final TransformServerInfo server;
    private final TransformRunOrigin runOrigin;

    public TransformRunnerContext(TransformsRunContext context, Map<EntityID, MaltegoEntity> inputEntities, Map<MaltegoLink, LinkEntityIDs> inputLinks, TransformDefinition transform, DataSource transformInputs, TransformServerInfo server, TransformRunOrigin runOrigin) {
        Args.notNull((Object)context, (String)"context");
        Args.notNull(inputEntities, (String)"inputEntities");
        Args.notNull(inputLinks, (String)"inputLinks");
        Args.notNull((Object)transform, (String)"transform");
        Args.notNull((Object)transformInputs, (String)"transformInputs");
        this.transformsContext = context;
        this.inputEntities = inputEntities;
        this.inputLinks = inputLinks;
        this.transform = transform;
        this.transformInputs = transformInputs;
        this.server = server;
        this.runOrigin = runOrigin;
    }

    public TransformsRunContext getTransformsContext() {
        return this.transformsContext;
    }

    public GraphID getTargetGraphID() {
        return this.getTransformsContext().getTargetGraphID();
    }

    public Map<EntityID, MaltegoEntity> getInputEntities() {
        return this.inputEntities;
    }

    public Map<MaltegoLink, LinkEntityIDs> getInputLinks() {
        return this.inputLinks;
    }

    public TransformDefinition getTransform() {
        return this.transform;
    }

    public DataSource getTransformInputs() {
        return this.transformInputs;
    }

    public EntityRegistry getEntityRegistry() {
        return this.getTransformsContext().getEntityRegistry();
    }

    public EntityFactory getEntityFactory() {
        return this.getTransformsContext().getEntityFactory();
    }

    public LinkFactory getLinkFactory() {
        return this.getTransformsContext().getLinkFactory();
    }

    public Optional<TransformServerInfo> getServer() {
        return Optional.ofNullable(this.server);
    }

    public Optional<String> getServerUrl() {
        String target = null;
        if (this.server != null) {
            FastURL v3url = this.server.getV3Url();
            if (v3url != null) {
                target = v3url.toString();
            } else {
                FastURL url = this.server.getUrl();
                if (url != null) {
                    target = url.toString();
                }
            }
        }
        return Optional.ofNullable(target);
    }

    public TransformRunOrigin getRunOrigin() {
        return this.runOrigin;
    }
}

