/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.types;

import com.pinkmatter.types.Coordinate;
import com.pinkmatter.types.Polygon;
import java.util.Objects;

public class Tetragon
extends Polygon {
    public static final int UPPER_RIGHT = 0;
    public static final int UPPER_LEFT = 1;
    public static final int LOWER_LEFT = 2;
    public static final int LOWER_RIGHT = 3;

    public Tetragon(Coordinate ur, Coordinate ul, Coordinate ll, Coordinate lr) {
        super(ur, ul, ll, lr);
    }

    public static Tetragon create(Coordinate ur, Coordinate ul, Coordinate ll, Coordinate lr) {
        return new Tetragon(ur, ul, ll, lr);
    }

    public Tetragon(double urLat, double urLon, double ulLat, double ulLon, double llLat, double llLon, double lrLat, double lrLon) {
        this(new Coordinate(urLat, urLon), new Coordinate(ulLat, ulLon), new Coordinate(llLat, llLon), new Coordinate(lrLat, lrLon));
    }

    @Override
    public Coordinate[] getOutline() {
        return super.getOutline();
    }

    @Override
    public Coordinate[][] getHoles() {
        return super.getHoles();
    }

    public Coordinate getUpperLeft() {
        return this.getOutline()[1];
    }

    public Coordinate getLowerLeft() {
        return this.getOutline()[2];
    }

    public Coordinate getLowerRight() {
        return this.getOutline()[3];
    }

    public Coordinate getUpperRight() {
        return this.getOutline()[0];
    }

    public boolean cross180Longitude() {
        Coordinate[] outline = this.getOutline();
        return Coordinate.cross180Longitude(outline[1], outline[3]) || Coordinate.cross180Longitude(outline[2], outline[0]);
    }

    public double getBottomLatitude() {
        Coordinate[] outline = this.getOutline();
        return Math.min(outline[2].getLatitude(), outline[3].getLatitude());
    }

    public double getTopLatitude() {
        Coordinate[] outline = this.getOutline();
        return Math.max(outline[1].getLatitude(), outline[0].getLatitude());
    }

    public double getLeftLongitude() {
        Coordinate[] outline = this.getOutline();
        double ll = outline[2].getLongitude();
        double ul = outline[1].getLongitude();
        double leftLon = this.cross180Longitude() && Coordinate.isEastLongitude(ll) != Coordinate.isEastLongitude(ll) ? Math.max(ul, ll) : Math.min(ul, ll);
        return leftLon;
    }

    public double getRightLongitude() {
        Coordinate[] outline = this.getOutline();
        double lr = outline[3].getLongitude();
        double ur = outline[0].getLongitude();
        double rightLon = this.cross180Longitude() && Coordinate.isEastLongitude(ur) != Coordinate.isEastLongitude(lr) ? Math.min(ur, lr) : Math.max(ur, lr);
        return rightLon;
    }

    public Tetragon getEastBounds() {
        double rightLon;
        double topLat = this.getTopLatitude();
        double bottomLat = this.getBottomLatitude();
        double leftLon = Math.max(this.getLeftLongitude(), 0.0);
        if (leftLon == (rightLon = this.cross180Longitude() ? 180.0 : Math.max(this.getRightLongitude(), 0.0))) {
            return null;
        }
        return new Tetragon(new Coordinate(topLat, rightLon), new Coordinate(topLat, leftLon), new Coordinate(bottomLat, leftLon), new Coordinate(bottomLat, rightLon));
    }

    public Tetragon getWestBounds() {
        double rightLon;
        double topLat = this.getTopLatitude();
        double bottomLat = this.getBottomLatitude();
        double leftLon = this.cross180Longitude() ? -180.0 : Math.min(this.getLeftLongitude(), 0.0);
        if (leftLon == (rightLon = Math.min(this.getRightLongitude(), 0.0))) {
            return null;
        }
        return new Tetragon(new Coordinate(topLat, rightLon), new Coordinate(topLat, leftLon), new Coordinate(bottomLat, leftLon), new Coordinate(bottomLat, rightLon));
    }

    public static Tetragon wholeWorld() {
        return new Tetragon(new Coordinate(90.0, 180.0), new Coordinate(90.0, -180.0), new Coordinate(-90.0, -180.0), new Coordinate(-90.0, 180.0));
    }

    @Override
    public String toString() {
        Coordinate[] outline = this.getOutline();
        return "UR(" + outline[0] + "), UL(" + outline[1] + "), LL(" + outline[2] + "), LR(" + outline[3] + ")";
    }

    @Override
    public int hashCode() {
        Coordinate[] outline = this.getOutline();
        int hash = 3;
        hash = 23 * hash + Objects.hashCode(outline[0]);
        hash = 23 * hash + Objects.hashCode(outline[1]);
        hash = 23 * hash + Objects.hashCode(outline[2]);
        hash = 23 * hash + Objects.hashCode(outline[3]);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Tetragon) {
            return this.equals((Tetragon)obj);
        }
        return false;
    }

    public boolean equals(Tetragon other) {
        if (other == null) {
            return false;
        }
        return this.getUpperLeft().equals(other.getUpperLeft()) && this.getLowerLeft().equals(other.getLowerLeft()) && this.getLowerRight().equals(other.getLowerRight()) && this.getUpperRight().equals(other.getUpperRight());
    }
}

