/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.actions.CookieAction;
import com.paterva.maltego.ui.graph.view2d.layout.MaltegoLabelLayouter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.openide.util.Utilities;
import yguard.A.A.D;
import yguard.A.A.E;
import yguard.A.A.H;
import yguard.A.A.Y;
import yguard.A.A.Z;
import yguard.A.D.r;
import yguard.A.G.S;
import yguard.A.G.b;
import yguard.A.G.m;
import yguard.A.G.n;
import yguard.A.J.BA;
import yguard.A.J.DA;
import yguard.A.J.SA;
import yguard.A.J.gB;
import yguard.A.J.y;

public class PlaceLabelsAction
extends CookieAction<GraphCookie> {
    private boolean _isRunning = false;

    public PlaceLabelsAction() {
        super(GraphCookie.class);
    }

    public String getName() {
        return "Re-arrange labels";
    }

    @Override
    protected void performAction(GraphCookie cookie) {
        if (cookie != null) {
            GraphID graphID = cookie.getGraphID();
            SA graph = GraphViewManager.getDefault().getViewGraph(graphID);
            if (graph instanceof SA) {
                this.perform(graph, null);
            }
        }
    }

    public void perform(final SA graph2D, final Runnable callback) {
        if (this._isRunning || graph2D.v() + graph2D.y() > 1000) {
            if (callback != null) {
                callback.run();
            }
            return;
        }
        this._isRunning = true;
        MaltegoLabelLayouter labelLayouter = new MaltegoLabelLayouter();
        final HashMap nodeMap = new HashMap();
        final HashMap edgeMap = new HashMap();
        DA executer = new DA(5){

            protected void applyGraphLayout(SA gd, S gl) {
                SwingUtilities.invokeLater(new GraphLayoutApplyer(graph2D, gl, nodeMap, edgeMap));
            }
        };
        r copier = new r((r._E)new y(){

            public H copyEdge(D graph, Y node, Y node1, H edge) {
                H copyEdge = super.copyEdge(graph, node, node1, edge);
                edgeMap.put(edge, copyEdge);
                return copyEdge;
            }

            public Y copyNode(D graph, Y node) {
                Y copyNode = super.copyNode(graph, node);
                nodeMap.put(node, copyNode);
                return copyNode;
            }
        });
        SA copy = (SA)copier.A((D)graph2D);
        executer.doLayout(copy, (n)labelLayouter, new Runnable(){

            @Override
            public void run() {
                PlaceLabelsAction.this._isRunning = false;
                graph2D.\u00f1().getComponent().repaint();
                if (callback != null) {
                    callback.run();
                }
            }
        }, null);
    }

    private static boolean areEqual(b left, b right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        if (right == null) {
            return false;
        }
        return left.getClass().equals(right.getClass());
    }

    private static class GraphLayoutApplyer
    implements Runnable {
        private final SA _graph2D;
        private final S _graphLayout;
        private Map<Y, Y> _nodeMap;
        private Map<H, H> _edgeMap;

        public GraphLayoutApplyer(SA gd, S gl, Map<Y, Y> nodeMap, Map<H, H> edgeMap) {
            this._graph2D = gd;
            this._graphLayout = gl;
            this._nodeMap = nodeMap;
            this._edgeMap = edgeMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                gB label;
                BA realizer;
                m labelLayout;
                int i;
                m[] labelLayouts;
                E nodes = this._graph2D.\u00a4();
                while (nodes.ok()) {
                    Y node = nodes.B();
                    Y copiedNode = this._nodeMap.get(node);
                    if (copiedNode != null && (labelLayouts = this._graphLayout.I((Object)copiedNode)) != null) {
                        for (i = 0; i < labelLayouts.length; ++i) {
                            b layoutLabelModel;
                            b labelModel;
                            labelLayout = labelLayouts[i];
                            if (labelLayout == null || (realizer = this._graph2D.f(node)) == null || realizer.labelCount() <= i || (label = realizer.getLabel(i)) == null || !PlaceLabelsAction.areEqual(labelModel = label.getLabelModel(), layoutLabelModel = labelLayout.getLabelModel())) continue;
                            label.setModelParameter(labelLayout.getModelParameter());
                        }
                    }
                    nodes.next();
                }
                Z edges = this._graph2D.u();
                while (edges.ok()) {
                    H edge = edges.D();
                    H copiedEdge = this._edgeMap.get(edge);
                    if (copiedEdge != null && (labelLayouts = this._graphLayout.H((Object)copiedEdge)) != null) {
                        for (i = 0; i < labelLayouts.length; ++i) {
                            labelLayout = labelLayouts[i];
                            if (labelLayout == null || (realizer = this._graph2D.X(edge)) == null || realizer.labelCount() <= i || (label = realizer.getLabel(i)) == null || !Utilities.compareObjects((Object)label.getLabelModel(), (Object)labelLayout.getLabelModel())) continue;
                            label.setModelParameter(labelLayout.getModelParameter());
                        }
                    }
                    edges.next();
                }
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }
}

