/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.actions.SelectionMode;
import com.paterva.maltego.ui.graph.actions.SelectionToggleAction;
import com.paterva.maltego.ui.graph.actions.TopGraphSelectionContextAction;
import java.util.HashSet;
import java.util.Set;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import yguard.A.J.SA;

public final class SelectSingleParentLeavesAction
extends TopGraphSelectionContextAction {
    public String getName() {
        return "Select Leaves";
    }

    @Override
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/SelectLeaves.png";
    }

    @Override
    protected boolean isEnabled(SA viewGraph) {
        GraphID graphID = viewGraph == null ? null : GraphIDProvider.forGraph((SA)viewGraph);
        return graphID != null;
    }

    @Override
    protected void actionPerformed(GraphView graphView) {
        try {
            GraphID graphID = this.getTopGraphID();
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            HashSet<EntityID> leafEntities = new HashSet<EntityID>();
            Set allEntityIds = structureReader.getEntities();
            if (allEntityIds == null || allEntityIds.isEmpty()) {
                return;
            }
            for (EntityID entityID : allEntityIds) {
                int incomingLinkCount = structureReader.getIncomingLinkCount(entityID);
                int outgoingLinkCount = structureReader.getOutgoingLinkCount(entityID);
                if (outgoingLinkCount != 0 || incomingLinkCount != 1) continue;
                leafEntities.add(entityID);
            }
            if (SelectionMode.isLinks()) {
                ((SelectionToggleAction)SystemAction.get(SelectionToggleAction.class)).performAction();
            }
            GraphSelection.forGraph((GraphID)graphID).setSelectedModelEntities(leafEntities);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

