/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

public class ShowLabels {
    private static ShowLabels _instance;
    private final int MANUAL = 0;
    private final int TRANSFORM = 1;
    private final String[] SHOW_LABELS_SETTING = new String[]{"showLabelsManual", "showLabelsTransform"};
    private boolean[] _showLabels = new boolean[2];
    private ChangeSupport _changeSupport;

    private ShowLabels() {
        Preferences settings = NbPreferences.forModule(ShowLabels.class);
        this._showLabels[0] = settings.getBoolean(this.SHOW_LABELS_SETTING[0], true);
        this._showLabels[1] = settings.getBoolean(this.SHOW_LABELS_SETTING[1], false);
        this._changeSupport = new ChangeSupport((Object)this);
    }

    public static synchronized ShowLabels instance() {
        if (_instance == null) {
            _instance = new ShowLabels();
        }
        return _instance;
    }

    public boolean isShowLabelsForManualLinks() {
        return this._showLabels[0];
    }

    public boolean isShowLabelsForTransformLinks() {
        return this._showLabels[1];
    }

    public boolean isShowLabelsForAllLinks() {
        return this._showLabels[0] && this._showLabels[1];
    }

    public void setShowLabelsForManualLinks(boolean showLabels) {
        if (this._showLabels[0] != showLabels) {
            this._showLabels[0] = showLabels;
            this.updateShowLabelsSetting(0);
            this.fireShowLabelsChanged();
        }
    }

    public void setShowLabelsForTransformLinks(boolean showLabels) {
        if (this._showLabels[1] != showLabels) {
            this._showLabels[1] = showLabels;
            this.updateShowLabelsSetting(1);
            this.fireShowLabelsChanged();
        }
    }

    public void setShowLabelsForAllLinks(boolean showLabels) {
        if ((this._showLabels[0] && this._showLabels[1]) != showLabels) {
            this._showLabels[0] = showLabels;
            this._showLabels[1] = showLabels;
            this.updateShowLabelsSetting(0);
            this.updateShowLabelsSetting(1);
            this.fireShowLabelsChanged();
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeSupport.removeChangeListener(listener);
    }

    private void updateShowLabelsSetting(int linkType) {
        Preferences settings = NbPreferences.forModule(ShowLabels.class);
        settings.putBoolean(this.SHOW_LABELS_SETTING[linkType], this._showLabels[linkType]);
    }

    private void fireShowLabelsChanged() {
        this._changeSupport.fireChange();
    }
}

