/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.transactions.properties;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.ui.graph.GraphUser;
import com.paterva.maltego.ui.graph.ModifiedHelper;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorRegistry;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.transactions.TransactionBatcher;
import com.paterva.maltego.util.SimilarStrings;

public class TransactionPropertyBatcher
extends TransactionBatcher {
    private final GraphID _graphID;
    private String _propertyName = "";

    public TransactionPropertyBatcher(GraphID graphID) {
        super(GraphTransactorRegistry.getDefault().get(graphID));
        this._graphID = graphID;
    }

    public synchronized void entityPropertyChanged(MaltegoEntity entityBefore, MaltegoEntity entity, PropertyDescriptor propertyDescriptor, Object before, Object after) {
        this._propertyName = propertyDescriptor.getDisplayName();
        ModifiedHelper.updateModified(GraphUser.getUser(this._graphID), (MaltegoPart<? extends Guid>)entity);
        GraphTransaction transaction = GraphTransactionHelper.createEntityUpdateTransaction(entityBefore, entity);
        GraphTransaction inverseTransaction = GraphTransactionHelper.createEntityUpdateTransaction(entity, entityBefore);
        this.addTransaction(transaction, inverseTransaction);
    }

    public synchronized void linkPropertyChanged(MaltegoLink linkBefore, MaltegoLink link, PropertyDescriptor propertyDescriptor, Object before, Object after) {
        this._propertyName = propertyDescriptor.getDisplayName();
        ModifiedHelper.updateModified(GraphUser.getUser(this._graphID), (MaltegoPart<? extends Guid>)link);
        GraphTransaction transaction = GraphTransactionHelper.createLinkUpdateTransaction(linkBefore, link);
        GraphTransaction inverseTransaction = GraphTransactionHelper.createLinkUpdateTransaction(link, linkBefore);
        this.addTransaction(transaction, inverseTransaction);
    }

    @Override
    protected SimilarStrings getDescription() {
        return new SimilarStrings("Change property \"" + SimilarStrings.escape((String)this._propertyName) + "\"");
    }
}

