/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.mtgx.dnd;

import com.paterva.maltego.archive.mtz.GraphFileType;
import com.paterva.maltego.util.ui.dnd.FileDropHandler;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class GraphFileDropHandler
extends FileDropHandler {
    public List<String> getLowercaseExtensions() {
        return Arrays.stream(GraphFileType.values()).map(GraphFileType::getExtension).collect(Collectors.toList());
    }

    public void handleDrop(List<File> validFiles) {
        validFiles.forEach(this::openGraph);
    }

    private void openGraph(File file) {
        try {
            FileObject fo = FileUtil.toFileObject((File)file);
            DataObject dao = DataObject.find((FileObject)fo);
            if (dao != null) {
                OpenCookie open = (OpenCookie)dao.getLookup().lookup(OpenCookie.class);
                open.open();
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

