/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.isg.pyramidio.stitching;

import gov.nist.isg.pyramidio.PartialImageReader;
import gov.nist.isg.pyramidio.stitching.ImageTile;
import gov.nist.isg.pyramidio.stitching.NormalBlender;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class MistStitchedImageReader
implements PartialImageReader {
    private final File tilesDirectory;
    private final FilenameConverter filenameConverter;
    private final List<ImageTile> tiles;
    private int tilesWidth;
    private int tilesHeight;
    private final int width;
    private final int height;
    private BufferedImage sampleImage;

    public MistStitchedImageReader(File positionFile, File tilesDirectory) throws IOException {
        this(positionFile, tilesDirectory, new FilenameConverter(){

            @Override
            public String convert(String fileName) {
                return fileName;
            }
        });
    }

    public MistStitchedImageReader(File positionFile, File tilesDirectory, FilenameConverter converter) throws IOException {
        this.tilesDirectory = tilesDirectory;
        this.filenameConverter = converter;
        this.tiles = this.getTilesFromPositionFile(positionFile);
        int maxX = 0;
        int maxY = 0;
        for (ImageTile tile : this.tiles) {
            Rectangle region = tile.getRegion();
            if (region.x > maxX) {
                maxX = region.x;
            }
            if (region.y <= maxY) continue;
            maxY = region.y;
        }
        this.width = maxX + this.tilesWidth;
        this.height = maxY + this.tilesHeight;
    }

    private void loadTilesDetails(File file) throws IOException {
        try (ImageInputStream iis = ImageIO.createImageInputStream(file);){
            if (iis == null) {
                throw new IOException("Can not create image input stream for file " + file);
            }
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (!readers.hasNext()) {
                throw new IOException("No image reader found for file " + file);
            }
            ImageReader reader = readers.next();
            reader.setInput(iis);
            this.tilesWidth = reader.getWidth(0);
            this.tilesHeight = reader.getHeight(0);
            ImageReadParam param = reader.getDefaultReadParam();
            param.setSourceRegion(new Rectangle(1, 1));
            this.sampleImage = reader.read(0, param);
        }
    }

    private List<ImageTile> getTilesFromPositionFile(File positionFile) throws IOException {
        String patternStr = "(\\S+): (\\S+|\\(\\S+, \\S+\\));";
        Pattern pattern = Pattern.compile(patternStr);
        ArrayList<ImageTile> tileList = new ArrayList<ImageTile>();
        try (BufferedReader br = new BufferedReader(new FileReader(positionFile));){
            String line;
            while ((line = br.readLine()) != null) {
                File file = null;
                double correlation = 0.0;
                int xPos = 0;
                int yPos = 0;
                Matcher matcher = pattern.matcher(line);
                while (matcher.find()) {
                    if (matcher.groupCount() != 2) continue;
                    String key = matcher.group(1);
                    String value = matcher.group(2);
                    switch (key) {
                        case "file": {
                            file = new File(this.tilesDirectory, this.filenameConverter.convert(value));
                            if (this.tilesWidth != 0 && this.tilesHeight != 0 && this.sampleImage != null) break;
                            this.loadTilesDetails(file);
                            break;
                        }
                        case "corr": {
                            try {
                                correlation = Double.parseDouble(value);
                                break;
                            }
                            catch (NumberFormatException e) {
                                throw new IOException(e);
                            }
                        }
                        case "position": {
                            value = value.replace("(", "");
                            value = value.replace(")", "");
                            String[] posSplit = value.split(",");
                            try {
                                xPos = Integer.parseInt(posSplit[0].trim());
                                yPos = Integer.parseInt(posSplit[1].trim());
                                break;
                            }
                            catch (NumberFormatException e) {
                                throw new IOException(e);
                            }
                        }
                    }
                }
                tileList.add(new ImageTile(file, new Rectangle(xPos, yPos, this.tilesWidth, this.tilesHeight), correlation));
            }
        }
        return tileList;
    }

    @Override
    public BufferedImage read(Rectangle rectangle) throws IOException {
        NormalBlender blender = new NormalBlender(rectangle.width, rectangle.height, this.sampleImage);
        for (ImageTile tile : this.tiles) {
            Rectangle intersection = tile.getIntersectionWithStitchedImageRegion(rectangle);
            if (intersection.isEmpty()) continue;
            BufferedImage region = tile.readStitchedImageRegion(rectangle);
            blender.blend(region, intersection.x - rectangle.x, intersection.y - rectangle.y);
        }
        return blender.getResult();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public List<ImageTile> getTiles() {
        return Collections.unmodifiableList(this.tiles);
    }

    public static interface FilenameConverter {
        public String convert(String var1);
    }
}

