/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.finder.auto;

import com.paterva.maltego.transform.finder.DiscoverySettings;
import com.paterva.maltego.transform.finder.SeedDiscoveryManager;
import com.paterva.maltego.transform.finder.UpdateInstalledSeedsAction;
import com.paterva.maltego.transform.finder.auto.AutoDiscoverySettings;
import com.paterva.maltego.transform.finder.auto.LicenseChangedHubUninstaller;
import com.paterva.maltego.util.ui.InactivityListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.modules.ModuleInstall;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class Installer
extends ModuleInstall {
    private static final Logger LOG = Logger.getLogger(Installer.class.getName());
    private long _lastDiscoverTime = 0L;

    public void restored() {
        LicenseChangedHubUninstaller.init();
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            InactivityListener.InactivitySingleton inactivity = InactivityListener.getSingleton();
            inactivity.addChangeListener(ignored -> {
                boolean active = inactivity.isActive();
                LOG.log(Level.FINE, "Is active: {0}", active);
                if (!active && DiscoverySettings.isDiscoveryComplete()) {
                    long timeSinceLastDiscover = System.currentTimeMillis() - this._lastDiscoverTime;
                    long rediscoverPeriod = AutoDiscoverySettings.getDefault().getRediscoverPeriodMinutes() * 60 * 1000;
                    LOG.log(Level.FINE, "Time since last discover: {0}", timeSinceLastDiscover);
                    LOG.log(Level.FINE, "Rediscover period: {0}", rediscoverPeriod);
                    if (timeSinceLastDiscover > rediscoverPeriod) {
                        LOG.fine("Scheduling updates");
                        UpdateInstalledSeedsAction action = (UpdateInstalledSeedsAction)SystemAction.get(UpdateInstalledSeedsAction.class);
                        action.performAction();
                        this._lastDiscoverTime = System.currentTimeMillis();
                    }
                }
            });
            SeedDiscoveryManager.getDefault().refreshHubWhiteList();
        });
    }
}

