/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora;

import com.pinkmatter.pandora.TypeUtils;
import java.lang.reflect.Array;
import java.util.Arrays;

public interface PandoraFilter<T>
extends Cloneable {
    public String getProperty();

    public Class getPropertyType();

    public boolean includeEmpty();

    public void setIncludeEmpty(boolean var1);

    public void setProperty(String var1);

    public Object clone();

    public static class Or
    extends BooleanWrapper {
        public Or(PandoraFilter ... filters) {
            super(filters);
        }

        public String toString() {
            return this.getDisplay("|");
        }
    }

    public static class And
    extends BooleanWrapper {
        public And(PandoraFilter ... filters) {
            super(filters);
        }

        public String toString() {
            return this.getDisplay("+");
        }
    }

    public static abstract class BooleanWrapper
    implements PandoraFilter {
        private final PandoraFilter[] _filters;

        public BooleanWrapper(PandoraFilter ... filters) {
            this._filters = filters;
        }

        public PandoraFilter[] getFilters() {
            return this._filters;
        }

        @Override
        public String getProperty() {
            throw new UnsupportedOperationException(String.format("BooleanWrapper Filter of type %s does not support this getProperty.", this.getClass()));
        }

        @Override
        public Class getPropertyType() {
            throw new UnsupportedOperationException(String.format("BooleanWrapper Filter of type %s does not support this getPropertyType.", this.getClass()));
        }

        @Override
        public boolean includeEmpty() {
            throw new UnsupportedOperationException(String.format("BooleanWrapper Filter of type %s does not support this includeEmpty.", this.getClass()));
        }

        @Override
        public void setIncludeEmpty(boolean include) {
            throw new UnsupportedOperationException(String.format("BooleanWrapper Filter of type %s does not support this setIncludeEmpty.", this.getClass()));
        }

        @Override
        public void setProperty(String property) {
            throw new UnsupportedOperationException(String.format("BooleanWrapper Filter of type %s does not support this setProperty.", this.getClass()));
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new Error("Error cloning PandoraFilter", ex);
            }
        }

        String getDisplay(String operator) {
            StringBuilder build = new StringBuilder("(");
            boolean first = true;
            for (PandoraFilter f : this.getFilters()) {
                if (first) {
                    build.append(f);
                    first = false;
                    continue;
                }
                build.append(" ");
                build.append(operator);
                build.append(" ");
                build.append(f);
            }
            build.append(")");
            return build.toString();
        }
    }

    public static class Not
    extends SingleWrapper {
        public Not(PandoraFilter filter) {
            super(filter);
        }

        public String toString() {
            return "Not " + this.getDisplay();
        }
    }

    public static abstract class SingleWrapper
    implements PandoraFilter {
        protected final PandoraFilter _filter;

        public SingleWrapper(PandoraFilter filter) {
            this._filter = filter;
        }

        public PandoraFilter getFilter() {
            return this._filter;
        }

        @Override
        public String getProperty() {
            return this._filter.getProperty();
        }

        @Override
        public Class getPropertyType() {
            return this._filter.getPropertyType();
        }

        @Override
        public boolean includeEmpty() {
            return this._filter.includeEmpty();
        }

        @Override
        public void setIncludeEmpty(boolean include) {
            this._filter.setIncludeEmpty(include);
        }

        @Override
        public void setProperty(String property) {
            this._filter.setProperty(property);
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new Error("Error cloning PandoraFilter", ex);
            }
        }

        String getDisplay() {
            return "(" + this.getFilter() + ")";
        }
    }

    public static class Like
    extends SingleValue<String> {
        public Like(String property, String query) {
            super(property, query);
        }

        public Like(String property, Class propertyType, String query) {
            super(property, propertyType, query);
        }

        public String toString() {
            return "Like " + this.getDisplay();
        }
    }

    public static class NotEmpty
    extends Simple {
        public NotEmpty(String property) {
            super(property);
        }

        public NotEmpty(String property, Class propertyType) {
            super(property, propertyType);
        }

        @Override
        public void setIncludeEmpty(boolean include) {
            throw new UnsupportedOperationException("Cannot set IncludeEmpty on NotEmpty filter.");
        }

        @Override
        public Class getType() {
            return Object.class;
        }

        @Override
        public Object getValueAsObject() {
            return null;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        public Object getValue() {
            return null;
        }

        public String toString() {
            return "NotEmpty" + this.getDisplay();
        }
    }

    public static class Empty
    extends Simple {
        public Empty(String property) {
            super(property);
        }

        public Empty(String property, Class propertyType) {
            super(property, propertyType);
        }

        @Override
        public void setIncludeEmpty(boolean include) {
            throw new UnsupportedOperationException("Cannot set IncludeEmpty on Empty filter.");
        }

        @Override
        public Class getType() {
            return Object.class;
        }

        @Override
        public Object getValueAsObject() {
            return null;
        }

        public String toString() {
            return "Empty" + this.getDisplay();
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        public Object getValue() {
            return null;
        }
    }

    public static class LessThan<T>
    extends SingleValue<T> {
        private boolean _including = false;

        public LessThan(String property, T values, boolean including) {
            this(property, null, values, including);
        }

        public LessThan(String property, Class propertyType, T values, boolean including) {
            super(property, propertyType, values);
            this._including = including;
        }

        public String toString() {
            return "LessThan " + this.getDisplay();
        }

        public boolean isIncluding() {
            return this._including;
        }
    }

    public static class GreaterThan<T>
    extends SingleValue<T> {
        private boolean _including = false;

        public GreaterThan(String property, T values, boolean including) {
            this(property, null, values, including);
        }

        public GreaterThan(String property, Class propertyType, T values, boolean including) {
            super(property, propertyType, values);
            this._including = including;
        }

        public String toString() {
            return "GreaterThan " + this.getDisplay();
        }

        public boolean isIncluding() {
            return this._including;
        }
    }

    public static class Between<T>
    extends Simple {
        private boolean _including = true;
        private T _from;
        private T _to;

        public Between(String property, T from, T to, boolean including) {
            this(property, null, from, to, including);
        }

        public Between(String property, Class propertyType, T from, T to, boolean including) {
            super(property, propertyType);
            this._from = from;
            this._to = to;
            this._including = including;
        }

        public boolean isIncluding() {
            return this._including;
        }

        public T getFrom() {
            return this._from;
        }

        public void setFrom(T from) {
            this._from = from;
        }

        public T getTo() {
            return this._to;
        }

        public void setTo(T to) {
            this._to = to;
        }

        @Override
        public Object getValueAsObject() {
            return new Object[]{this._from, this._to};
        }

        @Override
        public Class getType() {
            if (this._from != null) {
                return this._from.getClass();
            }
            if (this._to != null) {
                return this._to.getClass();
            }
            return null;
        }

        public String toString() {
            String type = this.getPropertyType() == null ? "" : "[" + this.getPropertyType() + "]";
            return "Between{" + this.getProperty() + type + " from=" + this._from + ", to=" + this._to + '}';
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        public Object getValue() {
            throw new UnsupportedOperationException("Use getFrom and getTo.");
        }
    }

    public static class IntersectsAny<T>
    extends Intersects<T> {
        public IntersectsAny(String property, T ... values) {
            super(false, property, values);
        }

        public IntersectsAny(String property, Class propertyType, T ... values) {
            super(true, property, propertyType, values);
        }
    }

    public static class Intersects<T>
    extends MultiValue<T> {
        public Intersects(String property, T ... values) {
            super(true, property, values);
        }

        public Intersects(String property, Class propertyType, T ... values) {
            super(true, property, propertyType, values);
        }

        protected Intersects(boolean matchAll, String property, T ... values) {
            super(matchAll, property, null, values);
        }

        protected Intersects(boolean matchAll, String property, Class propertyType, T ... values) {
            super(matchAll, property, propertyType, values);
        }

        @Override
        protected MultiValue<T> createSingleFilter(String property, Class propertyType, T[] values) {
            return new Intersects<T>(property, propertyType, values);
        }

        public String toString() {
            return "Intersects " + this.getDisplay();
        }
    }

    public static class WithinAny<T>
    extends Within<T> {
        public WithinAny(String property, T ... values) {
            super(false, property, values);
        }

        public WithinAny(String property, Class propertyType, T ... values) {
            super(true, property, propertyType, values);
        }
    }

    public static class Within<T>
    extends MultiValue<T> {
        public Within(String property, T ... values) {
            super(true, property, values);
        }

        public Within(String property, Class propertyType, T ... values) {
            super(true, property, propertyType, values);
        }

        protected Within(boolean matchAll, String property, T ... values) {
            super(matchAll, property, null, values);
        }

        protected Within(boolean matchAll, String property, Class propertyType, T ... values) {
            super(matchAll, property, propertyType, values);
        }

        @Override
        protected MultiValue<T> createSingleFilter(String property, Class propertyType, T[] values) {
            return new Within<T>(property, propertyType, values);
        }

        public String toString() {
            return "Within " + this.getDisplay();
        }
    }

    public static class ContainsAny<T>
    extends Contains<T> {
        public ContainsAny(String property, T ... values) {
            super(false, property, values);
        }

        public ContainsAny(String property, Class propertyType, T ... values) {
            super(true, property, propertyType, values);
        }
    }

    public static class Contains<T>
    extends MultiValue<T> {
        public Contains(String property, T ... values) {
            super(true, property, values);
        }

        public Contains(String property, Class propertyType, T ... values) {
            super(true, property, propertyType, values);
        }

        protected Contains(boolean matchAll, String property, T ... values) {
            super(matchAll, property, null, values);
        }

        protected Contains(boolean matchAll, String property, Class propertyType, T ... values) {
            super(matchAll, property, propertyType, values);
        }

        @Override
        protected MultiValue<T> createSingleFilter(String property, Class propertyType, T[] values) {
            return new Contains<T>(property, propertyType, values);
        }

        public String toString() {
            return "Contains " + this.getDisplay();
        }
    }

    public static abstract class MultiValue<T>
    extends Simple {
        private T[] _values;
        private boolean _all = true;

        public MultiValue(boolean matchAll, String property, T ... values) {
            this(matchAll, property, null, values);
        }

        public MultiValue(boolean matchAll, String property, Class propertyType, T ... values) {
            super(property, propertyType);
            this.setValue(values);
            this._all = matchAll;
        }

        public T[] getValues() {
            return this._values;
        }

        @Override
        public T getValue() {
            if (this._values.length > 0) {
                return this._values[0];
            }
            return null;
        }

        private void setValue(T ... values) {
            if ((values = TypeUtils.toObject(values)) == null || values.length == 0) {
                throw new IllegalArgumentException("Values cannot be empty.");
            }
            this._values = values;
        }

        public MultiValue<T>[] toSingleValuedFilters() {
            MultiValue[] filters = new MultiValue[this._values.length];
            int i = 0;
            for (T val : this._values) {
                filters[i] = this.createSingleFilter(this.getProperty(), this.getPropertyType(), this.toArray(val));
                ++i;
            }
            return filters;
        }

        private T[] toArray(T value) {
            Object array = Array.newInstance(value.getClass(), 1);
            Array.set(array, 0, value);
            return (Object[])array;
        }

        protected abstract MultiValue<T> createSingleFilter(String var1, Class var2, T[] var3);

        @Override
        public Object getValueAsObject() {
            return this._values;
        }

        @Override
        public boolean isMultiValued() {
            return this._values.length > 1;
        }

        public boolean isMatchAll() {
            return this._all;
        }

        @Override
        public Class getType() {
            return TypeUtils.getDeepType(this._values);
        }

        @Override
        String getDisplay() {
            String type = this.getPropertyType() == null ? "" : "[" + this.getPropertyType() + "]";
            return (this.isMatchAll() ? "ALL" : "ANY") + " {" + this.getProperty() + type + "=" + Arrays.toString(this.getValues()) + '}';
        }
    }

    public static abstract class SingleValue<T>
    extends Simple {
        private T _value;

        public SingleValue(String property, T value) {
            this(property, null, value);
        }

        public SingleValue(String property, Class propertyType, T value) {
            super(property, propertyType);
            if (value == null) {
                throw new IllegalArgumentException("Value cannot be null.");
            }
            if (value.getClass() == Object.class) {
                throw new IllegalArgumentException("Value of type Object is not supported. Use the diamond operator <> in stead.");
            }
            if (value.getClass().isArray()) {
                throw new IllegalArgumentException("Array value not allowed.");
            }
            this._value = value;
        }

        @Override
        public T getValue() {
            return this._value;
        }

        private void setValue(T value) {
            this._value = value;
        }

        @Override
        public Object getValueAsObject() {
            return this._value;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public Class getType() {
            if (this._value != null) {
                return this._value.getClass();
            }
            return null;
        }

        @Override
        String getDisplay() {
            String type = this.getPropertyType() == null ? "" : "[" + this.getPropertyType() + "]";
            return "{" + this.getProperty() + type + "=" + this.getValue() + "}";
        }
    }

    public static abstract class Simple<T>
    implements PandoraFilter {
        private boolean _includeEmpty;
        private String _property;
        private Class _propertyType;

        public Simple(String property) {
            this(property, null);
        }

        public Simple(String property, Class propertyType) {
            this._property = property;
            this._includeEmpty = false;
            this._propertyType = propertyType;
        }

        @Override
        public String getProperty() {
            return this._property;
        }

        @Override
        public Class getPropertyType() {
            return this._propertyType;
        }

        @Override
        public void setProperty(String property) {
            this._property = property;
        }

        @Override
        public boolean includeEmpty() {
            return this._includeEmpty;
        }

        @Override
        public void setIncludeEmpty(boolean include) {
            this._includeEmpty = include;
        }

        public abstract boolean isMultiValued();

        public abstract T getValue();

        public abstract Object getValueAsObject();

        public abstract Class getType();

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new Error("Error cloning PandoraFilter", ex);
            }
        }

        String getDisplay() {
            String type = this._propertyType == null ? "" : "[" + this._propertyType + "]";
            return "{" + this._property + type + "}";
        }
    }
}

