/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.impl;

import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.graph.table.io.impl.PropertyToColumnMapImpl;
import com.paterva.maltego.typing.PropertyDescriptor;

public class DefaultTabularGraphLink
extends PropertyToColumnMapImpl
implements TabularGraphLink {
    private final TabularGraphEntity _source;
    private final TabularGraphEntity _target;
    private int _index;

    public DefaultTabularGraphLink(TabularGraphEntity source, TabularGraphEntity target) {
        this._source = source;
        this._target = target;
    }

    public DefaultTabularGraphLink(TabularGraphLink link, TabularGraphEntity source, TabularGraphEntity target) {
        this(source, target);
        this._index = link.getIndex();
        for (int column : link.getColumns()) {
            PropertyDescriptor pd = new PropertyDescriptor(link.getProperty(column));
            this.put(column, pd);
        }
    }

    public int getIndex() {
        return this._index;
    }

    public void setIndex(int index) {
        this._index = index;
    }

    public TabularGraphEntity getSource() {
        return this._source;
    }

    public TabularGraphEntity getTarget() {
        return this._target;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Link ");
        sb.append(this._index);
        sb.append(" (");
        sb.append(this._source.getEntitySpecName());
        sb.append(" -> ");
        sb.append(this._target.getEntitySpecName());
        sb.append(")");
        return sb.toString();
    }
}

