/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions;

import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.Payloads;
import com.paterva.maltego.automation.actions.GraphHelper;
import com.paterva.maltego.automation.actions.NumericFilter;
import com.paterva.maltego.automation.actions.NumericFilterSupport;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import java.util.Set;
import org.openide.util.Exceptions;

public class RootAncestorCountFilter
extends NumericFilter {
    public RootAncestorCountFilter() {
        super("rootAncestorCount");
    }

    @Override
    protected Payloads.EntityFilter createEntityFilter(AutomationContext ctx, double equalTo, double moreThan, double lessThan, double moreThanOrEqual, double lessThanOrEqual, boolean invert) {
        return new RootParentCountEntityFilter(ctx, equalTo, moreThan, lessThan, moreThanOrEqual, lessThanOrEqual, invert);
    }

    private static class RootParentCountEntityFilter
    extends NumericFilterSupport.NumericEntityFilter {
        public RootParentCountEntityFilter(AutomationContext ctx, double equalTo, double moreThan, double lessThan, double moreThanOrEqual, double lessThanOrEqual, boolean invert) {
            super(ctx, equalTo, moreThan, lessThan, moreThanOrEqual, lessThanOrEqual, invert);
        }

        @Override
        public boolean pass(MaltegoEntity entity) {
            boolean pass = false;
            try {
                int count = this.getRootCount((EntityID)entity.getID());
                pass = NumericFilterSupport.check(count, this.getEqualTo(), this.getMoreThan(), this.getLessThan(), this.getMoreThanOrEqual(), this.getLessThanOrEqual());
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return pass;
        }

        private int getRootCount(EntityID entityID) throws GraphStoreException {
            GraphID graphID = this.getContext().getTargetGraphID();
            Set<EntityID> roots = GraphHelper.getRootParents(entityID, graphID);
            int count = roots.size();
            return count;
        }
    }
}

