/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions;

import com.paterva.maltego.automation.Action;
import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.MachineMessageHandler;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.actions.AbstractAction;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutMode;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutSettings;
import org.openide.windows.TopComponent;

public class SetLayoutAction
extends AbstractAction {
    private static final String INTERACTIVE = "Interactive";
    private static final LayoutMode[] SUPPORTED_LAYOUTS = new LayoutMode[]{LayoutMode.BLOCK, LayoutMode.HIERARCHICAL, LayoutMode.CIRCULAR, LayoutMode.ORGANIC, LayoutMode.INTERACTIVE_ORGANIC};

    public SetLayoutAction() {
        super("setLayout");
    }

    @Override
    public void start(AutomationContext ctx, Payload payload, Action.Callback cb) {
        String layout = (String)this.getValueOrProperty("layout");
        String scope = (String)this.getProperty("scope", "global");
        LayoutMode mode = this.getMode(layout);
        if (mode == null) {
            this.onModeNotFound(ctx, layout);
        } else {
            ctx.getLogger().info("Setting layout to " + mode.getName(), new Object[0]);
            if ("global".equals(scope)) {
                this.setLayout(ctx, mode, true);
            } else if ("local".equals(scope)) {
                this.setLayout(ctx, mode, false);
            } else {
                MachineMessageHandler.getDefault().error(ctx.getTarget(), "Unknown scope: " + scope, new Object[0]);
            }
        }
        cb.completed(payload);
    }

    private void setLayout(AutomationContext ctx, LayoutMode mode, boolean global) {
        GraphView graphView = this.getActiveGraphView(ctx);
        if (graphView != null) {
            MachineMessageHandler.getDefault().info(ctx.getTarget(), "Layout set to %s", this.getName(mode));
            graphView.setLayout(new LayoutSettings(global, mode), false);
        } else {
            MachineMessageHandler.getDefault().error(ctx.getTarget(), "Graph view not found for machine.", new Object[0]);
        }
    }

    private GraphView getActiveGraphView(AutomationContext ctx) {
        TopComponent topComponent = ctx.getTopComponent();
        if (topComponent != null) {
            GraphViewCookie cookie = (GraphViewCookie)topComponent.getLookup().lookup(GraphViewCookie.class);
            if (cookie != null) {
                return cookie.getGraphView();
            }
        } else {
            MachineMessageHandler.getDefault().error(ctx.getTarget(), "Top component not found for machine.", new Object[0]);
        }
        return null;
    }

    private void onModeNotFound(AutomationContext ctx, String mode) {
        StringBuilder sb = new StringBuilder("Unknown layout mode \"");
        sb.append(mode);
        sb.append("\", try one of the following: ");
        sb.append(this.getAllModesString());
        MachineMessageHandler.getDefault().error(ctx.getTarget(), sb.toString(), new Object[0]);
    }

    private String getAllModesString() {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (LayoutMode layoutMode : SUPPORTED_LAYOUTS) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(this.getName(layoutMode));
        }
        sb.append("]");
        return sb.toString();
    }

    private LayoutMode getMode(String name) {
        if (name != null && INTERACTIVE.toLowerCase().equals(name.toLowerCase())) {
            return LayoutMode.INTERACTIVE_ORGANIC;
        }
        return LayoutMode.getMode((String)name);
    }

    private String getName(LayoutMode mode) {
        if (LayoutMode.INTERACTIVE_ORGANIC.equals((Object)mode)) {
            return INTERACTIVE;
        }
        return mode.getName();
    }
}

