/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.language;

import com.paterva.maltego.automation.Action;
import com.paterva.maltego.automation.ActionRegistry;
import com.paterva.maltego.automation.PropertySupport;
import com.paterva.maltego.automation.language.CodeElement;
import com.paterva.maltego.automation.language.ControlStructure;
import com.paterva.maltego.automation.language.Function;
import com.paterva.maltego.automation.language.Machine;
import com.paterva.maltego.automation.language.Macro;
import com.paterva.maltego.automation.language.SequentialStructure;
import com.paterva.maltego.automation.language.SplitStructure;
import com.paterva.maltego.automation.language.Statement;
import com.paterva.maltego.automation.language.Timer;
import groovy.util.BuilderSupport;
import java.util.HashMap;
import java.util.Map;

class MachineBuilder
extends BuilderSupport {
    private Automaton _automaton;
    private final ActionRegistry _actionRegistry;

    public MachineBuilder(ActionRegistry registry) {
        this._actionRegistry = registry;
    }

    public Machine getMachine() {
        if (this._automaton != null) {
            return this._automaton.getMachine();
        }
        return null;
    }

    public Macro getMacro() {
        if (this._automaton != null) {
            return this._automaton.getMacro();
        }
        return null;
    }

    protected void setParent(Object parent, Object child) {
    }

    protected Object createNode(Object name) {
        if (name.equals("automaton")) {
            return new Automaton();
        }
        if (name.equals("machine")) {
            return new Machine();
        }
        if (name.equals("macro")) {
            return new Macro();
        }
        if (name.equals("function")) {
            return new Function();
        }
        if (name.equals("onTimer")) {
            return new Timer();
        }
        if (name.equals("paths")) {
            return new SplitStructure();
        }
        if (name.equals("path")) {
            return new SequentialStructure();
        }
        if (name.equals("start")) {
            return new MainFunction();
        }
        if (name != null) {
            Action action = this.getAction(name.toString());
            return new Statement(action);
        }
        System.out.println("Unknown node: " + name);
        return null;
    }

    protected Action getAction(String name) {
        return this._actionRegistry.get(name);
    }

    protected Object createNode(Object name, Object value) {
        return this.createNode(name, null, value);
    }

    protected Object createNode(Object name, Map map) {
        return this.createNode(name, map, null);
    }

    protected Object createNode(Object name, Map map, Object value) {
        Object node = this.createNode(name);
        if (node instanceof PropertySupport) {
            PropertySupport support = (PropertySupport)node;
            support.setValue(value);
            this.copyProperties(map, support);
        }
        return node;
    }

    protected void nodeCompleted(Object parent, Object node) {
        if (parent instanceof Automaton) {
            this.attachToAutomaton((Automaton)parent, node);
        }
        if (parent instanceof Machine) {
            this.attachToMachine((Machine)parent, node);
        } else if (parent == null && node instanceof Automaton) {
            this._automaton = (Automaton)node;
        } else if (parent instanceof ControlStructure) {
            this.attachToControlStructure((ControlStructure)parent, node);
        }
    }

    private boolean contains(String[] array, Object name) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    private String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private String getString(Map map, String name) {
        if (map == null) {
            return null;
        }
        return this.toString(map.get(name));
    }

    private String getNonNull(String a, String b) {
        if (a != null) {
            return a;
        }
        return b;
    }

    private void copyProperties(Map map, PropertySupport support) {
        if (map != null) {
            for (Map.Entry e : map.entrySet()) {
                Map.Entry entry = e;
                if (!(entry.getKey() instanceof String)) continue;
                support.putProperty((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private void attachToMachine(Machine machine, Object node) {
        if (node instanceof MainFunction) {
            machine.setMain((Function)node);
        } else if (node instanceof Timer) {
            machine.setMain((Function)node);
            machine.setTimer((Timer)node);
        }
    }

    private void attachToAutomaton(Automaton automaton, Object node) {
        if (node instanceof Macro) {
            automaton.setMacro((Macro)node);
        } else if (node instanceof Machine) {
            automaton.setMachine((Machine)node);
        } else if (node instanceof Function) {
            automaton.addFunction((Function)node);
        }
    }

    private void attachToControlStructure(ControlStructure controlStructure, Object node) {
        if (node instanceof CodeElement) {
            controlStructure.addChild((CodeElement)node);
        }
    }

    private class Automaton {
        private Machine _machine;
        private Macro _macro;
        private Map<String, Function> _functions;

        private Automaton() {
        }

        public Machine getMachine() {
            return this._machine;
        }

        public Macro getMacro() {
            return this._macro;
        }

        public void setMachine(Machine machine) {
            this._machine = machine;
        }

        public void setMacro(Macro macro) {
            this._macro = macro;
        }

        public void addFunction(Function function) {
            if (this._functions == null) {
                this._functions = new HashMap<String, Function>();
            }
            this._functions.put(function.getName(), function);
        }
    }

    private class MainFunction
    extends Function {
        private MainFunction() {
        }
    }
}

