/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.pws;

import com.paterva.maltego.pws.AccountTableModel;
import com.paterva.maltego.pws.FixedAccountTableModel;
import com.paterva.maltego.pws.RegistryAccountTableModel;
import com.paterva.maltego.pws.api.PublicWebService;
import com.paterva.maltego.pws.api.SignInFailedCallback;
import com.paterva.maltego.util.ui.components.MatteBorderLeft;
import com.paterva.maltego.util.ui.table.ButtonNameProvider;
import com.paterva.maltego.util.ui.table.EditableTableDecorator;
import com.paterva.maltego.util.ui.table.ImageTableCellRenderer;
import com.paterva.maltego.util.ui.table.PaddedTableCellRenderer;
import com.paterva.maltego.util.ui.table.TableButtonEvent;
import com.paterva.maltego.util.ui.table.TableButtonListener;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.EventObject;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.html.HTMLDocument;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.jdesktop.swingx.painter.BusyPainter;
import org.netbeans.swing.etable.ETable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AccountManagerPanel
extends JPanel {
    private static final String SERVICES = "Services";
    private static final String PROGRESS = "Progress";
    private PublicWebService _signInService;
    private ActionListener _cancelListener;
    private PropertyChangeListener _serviceListener;
    private AccountTableModel _accountTableModel;
    private final JButton _signInButton = new JButton("Sign Out");
    private final Set<PublicWebService> _fixedServices;
    private ETable _accountTable;
    private JPanel _busyPanel;
    private JButton _cancelButton;
    private JPanel _cardPanel;
    private JTextArea _descriptionTextArea;
    private JPanel _progressPanel;
    private JPanel _servicesPanel;
    private JPanel _servicesParentPanel;
    private JEditorPane _stepsEditorPane;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane2;

    public AccountManagerPanel(Set<PublicWebService> services) {
        this._fixedServices = services;
        this._signInButton.setActionCommand("Sign In/Out");
        this.initComponents();
        this.initSteps();
        this.initBusyPanel();
        this.initTable();
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, SERVICES);
    }

    private void initBusyPanel() {
        this._busyPanel.setLayout(new BorderLayout());
        int size = 40;
        JXBusyLabel label = new JXBusyLabel(new Dimension(40, 40));
        BusyPainter painter = new BusyPainter(40);
        painter.setTrailLength(2);
        painter.setPoints(10);
        painter.setPointShape((Shape)new RoundRectangle2D.Float(4.0f, 4.0f, 20.0f, 8.0f, 8.0f, 8.0f));
        painter.setFrame(1);
        label.setPreferredSize(new Dimension(40, 40));
        label.setIcon((Icon)new EmptyIcon(40, 40));
        label.setBusyPainter(painter);
        label.setBusy(true);
        label.setHorizontalAlignment(0);
        this._busyPanel.add((Component)label);
    }

    private void initSteps() {
        Font font = this._stepsEditorPane.getFont();
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)this._stepsEditorPane.getDocument()).getStyleSheet().addRule(bodyRule);
    }

    private void initTable() {
        this._accountTableModel = this._fixedServices != null ? new FixedAccountTableModel(this._fixedServices) : new RegistryAccountTableModel();
        this._accountTable.setModel((TableModel)this._accountTableModel);
        EditableTableDecorator decorator = new EditableTableDecorator();
        ButtonListener tableButtonListener = new ButtonListener();
        if (this._fixedServices != null) {
            decorator.addTableButtons((JTable)this._accountTable, (TableButtonListener)tableButtonListener, new JButton[]{this._signInButton}, new boolean[]{false}, new boolean[]{true}, (ButtonNameProvider)new SignInButtonNameProvider());
        } else {
            decorator.addTableButtons((JTable)this._accountTable, (TableButtonListener)tableButtonListener, new JButton[]{this._signInButton, decorator.createDeleteButton()}, new boolean[]{false, true}, new boolean[]{true, false}, (ButtonNameProvider)new SignInButtonNameProvider());
        }
        this._accountTable.setDefaultRenderer(Image.class, (TableCellRenderer)new ImageTableCellRenderer());
        this._accountTable.setDefaultRenderer(String.class, (TableCellRenderer)new PaddedTableCellRenderer());
        this._accountTable.setAutoCreateColumnsFromModel(false);
        this._accountTable.setRowHeight(25);
        TableColumnModel columnModel = this._accountTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(20);
        columnModel.getColumn(0).setMaxWidth(20);
        columnModel.getColumn(1).setPreferredWidth(125);
        columnModel.getColumn(2).setPreferredWidth(170);
        TableColumn colProtocol = columnModel.getColumn(3);
        colProtocol.setPreferredWidth(115);
        colProtocol.setCellEditor(new ProtocolComboCellEditor());
        TableColumn colPort = columnModel.getColumn(4);
        colPort.setPreferredWidth(115);
        colPort.setCellEditor(new PortTextCellEditor());
        this._accountTable.setSelectionMode(1);
    }

    private String getButtonText(int row) {
        String name = null;
        PublicWebService service = null;
        try {
            service = this._accountTableModel.getService(this._accountTable.convertRowIndexToModel(row));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (service != null) {
            name = service.isSigningIn() ? "Working..." : (service.getSignedIn().isEmpty() ? "Sign In" : "Sign Out");
        }
        return name;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._serviceListener = new ServiceListener();
        this._cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountManagerPanel.this._cancelButton.setEnabled(false);
                AccountManagerPanel.this._signInService.cancelSigningIn();
            }
        };
        this._cancelButton.addActionListener(this._cancelListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._signInService != null) {
            this._signInService.cancelSigningIn();
        }
        this._serviceListener = null;
        this._cancelButton.removeActionListener(this._cancelListener);
        this._cancelListener = null;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this._descriptionTextArea = new JTextArea();
        this.jPanel3 = new JPanel();
        this._cardPanel = new JPanel();
        this._servicesParentPanel = new JPanel();
        this._servicesPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this._accountTable = new ETable();
        this._progressPanel = new JPanel();
        this._cancelButton = new JButton();
        this._busyPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this._stepsEditorPane = new JEditorPane();
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setMinimumSize(new Dimension(720, 600));
        this.setPreferredSize(new Dimension(720, 600));
        this.setLayout(new BorderLayout(0, 6));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), NbBundle.getMessage(AccountManagerPanel.class, (String)"AccountManagerPanel.jPanel1.border.title")));
        this.jPanel1.setLayout(new BorderLayout());
        this._descriptionTextArea.setEditable(false);
        this._descriptionTextArea.setFont(new JLabel().getFont());
        this._descriptionTextArea.setLineWrap(true);
        this._descriptionTextArea.setText(NbBundle.getMessage(AccountManagerPanel.class, (String)"AccountManagerPanel._descriptionTextArea.text"));
        this._descriptionTextArea.setWrapStyleWord(true);
        this._descriptionTextArea.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this._descriptionTextArea.setOpaque(false);
        this.jPanel1.add((Component)this._descriptionTextArea, "Center");
        this.add((Component)this.jPanel1, "North");
        this.jPanel3.setLayout(new BorderLayout(0, 10));
        this._cardPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 1));
        this._cardPanel.setLayout(new CardLayout());
        this._servicesParentPanel.setLayout(new BorderLayout());
        this._servicesPanel.setLayout(new BorderLayout());
        this._accountTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this._accountTable.setFillsViewportHeight(true);
        this.jScrollPane2.setViewportView((Component)this._accountTable);
        this._servicesPanel.add((Component)this.jScrollPane2, "Center");
        this._servicesParentPanel.add((Component)this._servicesPanel, "Center");
        this._cardPanel.add((Component)this._servicesParentPanel, SERVICES);
        this._progressPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), NbBundle.getMessage(AccountManagerPanel.class, (String)"AccountManagerPanel._progressPanel.border.outsideBorder.insideBorder.title"))), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this._progressPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this._cancelButton, (String)NbBundle.getMessage(AccountManagerPanel.class, (String)"AccountManagerPanel._cancelButton.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this._progressPanel.add((Component)this._cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this._progressPanel.add((Component)this._busyPanel, gridBagConstraints);
        this._cardPanel.add((Component)this._progressPanel, PROGRESS);
        this.jPanel3.add((Component)this._cardPanel, "Center");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), NbBundle.getMessage(AccountManagerPanel.class, (String)"AccountManagerPanel.jPanel2.border.title")));
        this.jPanel2.setLayout(new BorderLayout());
        this._stepsEditorPane.setEditable(false);
        this._stepsEditorPane.setBorder(BorderFactory.createEmptyBorder(6, 3, 0, 6));
        this._stepsEditorPane.setContentType("text/html");
        this._stepsEditorPane.setForeground(UIManager.getLookAndFeelDefaults().getColor("7-black"));
        this._stepsEditorPane.setText(NbBundle.getMessage(AccountManagerPanel.class, (String)"AccountManagerPanel._stepsEditorPane.text"));
        this._stepsEditorPane.setOpaque(false);
        this.jPanel2.add((Component)this._stepsEditorPane, "Center");
        this.jPanel3.add((Component)this.jPanel2, "North");
        this.add((Component)this.jPanel3, "Center");
    }

    private class SignInButtonNameProvider
    implements ButtonNameProvider {
        private SignInButtonNameProvider() {
        }

        public String getName(int row, int col) {
            String name = null;
            if (col == 5) {
                name = AccountManagerPanel.this.getButtonText(row);
            }
            return name;
        }
    }

    private class ButtonListener
    implements TableButtonListener {
        private ButtonListener() {
        }

        public void actionPerformed(TableButtonEvent evt) {
            if ("delete".equals(evt.getActionCommand())) {
                int[] rows = evt.getSelectedRows();
                if (rows != null && evt.getSelectedRows().length > 0 && this.ask()) {
                    int[] modelRows = new int[rows.length];
                    for (int i = 0; i < rows.length; ++i) {
                        modelRows[i] = AccountManagerPanel.this._accountTable.convertRowIndexToModel(rows[i]);
                    }
                    if (AccountManagerPanel.this._accountTableModel instanceof RegistryAccountTableModel) {
                        ((RegistryAccountTableModel)AccountManagerPanel.this._accountTableModel).remove(modelRows);
                    }
                }
            } else {
                int row = AccountManagerPanel.this._accountTable.convertRowIndexToModel(evt.getSelectedRows()[0]);
                PublicWebService service = AccountManagerPanel.this._accountTableModel.getService(row);
                if (service != null) {
                    if (service.getSignedIn().isEmpty()) {
                        service.addPropertyChangeListener(AccountManagerPanel.this._serviceListener);
                        service.signIn((SignInFailedCallback)new SignInCallback(service));
                    } else {
                        service.signOut((String)service.getSignedIn().iterator().next());
                    }
                }
            }
        }

        private boolean ask() {
            return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)"Remove selected service(s) from Maltego?", "Delete selection", 1, 3, null, NotifyDescriptor.YES_OPTION)) == NotifyDescriptor.YES_OPTION;
        }
    }

    private static class SignInCallback
    implements SignInFailedCallback {
        private final PublicWebService _service;

        public SignInCallback(PublicWebService service) {
            this._service = service;
        }

        public void failed(Exception ex) {
            String msg = "Failed to sign into " + this._service.getDisplayName() + ".\n\n" + ex.getMessage();
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg);
            nd.setTitle("Sign in failed");
            nd.setMessageType(0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }

    private class ServiceListener
    implements PropertyChangeListener {
        private ServiceListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PublicWebService service = (PublicWebService)evt.getSource();
            if ("accountAdded".equals(evt.getPropertyName())) {
                this.updateSignInButton(service);
            } else if ("accountRemoved".equals(evt.getPropertyName())) {
                this.updateSignInButton(service);
            } else if ("signingIn".equals(evt.getPropertyName())) {
                boolean signingIn = (Boolean)evt.getNewValue();
                ((CardLayout)AccountManagerPanel.this._cardPanel.getLayout()).show(AccountManagerPanel.this._cardPanel, signingIn ? AccountManagerPanel.PROGRESS : AccountManagerPanel.SERVICES);
                AccountManagerPanel.this._cancelButton.setEnabled(signingIn);
                if (signingIn) {
                    AccountManagerPanel.this._signInService = service;
                } else {
                    AccountManagerPanel.this._signInService.removePropertyChangeListener(AccountManagerPanel.this._serviceListener);
                    AccountManagerPanel.this._signInService = null;
                }
            }
        }

        private void updateSignInButton(PublicWebService service) {
            AccountManagerPanel.this._accountTableModel.update(service, 5);
        }
    }

    private class PortTextCellEditor
    extends DefaultCellEditor {
        private final JSpinner _spinner;

        public PortTextCellEditor() {
            super(new JTextField());
            this._spinner = new JSpinner(new SpinnerNumberModel(0, -1, Integer.MAX_VALUE, 1));
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Integer port = -1;
            try {
                port = Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this._spinner.setValue(port);
            return this._spinner;
        }

        @Override
        public boolean isCellEditable(EventObject evt) {
            return true;
        }

        @Override
        public int getClickCountToStart() {
            return 1;
        }

        @Override
        public boolean stopCellEditing() {
            try {
                this._spinner.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return super.stopCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            return this._spinner.getValue();
        }
    }

    private class ProtocolComboCellEditor
    extends DefaultCellEditor {
        public ProtocolComboCellEditor() {
            super(new JComboBox<String>(new String[]{"http", "https"}));
        }
    }
}

