/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.pws.oauth;

import com.paterva.maltego.pws.api.OAuthAuthenticator;
import com.paterva.maltego.pws.api.OAuthVersion;
import java.util.Objects;

class GenericOAuthAuthenticator
implements OAuthAuthenticator {
    private String _accessTokenEndpoint = "";
    private String _accessTokenInput = "";
    private String _accessTokenPublicKey = "";
    private String _appKey = "";
    private String _appSecret = "";
    private String _authorizationUrl = "";
    private Integer _callbackPort = null;
    private boolean _callbackPortUserModified = false;
    private String _description = "";
    private String _displayName = "";
    private String _icon = "";
    private String _name = "";
    private OAuthVersion _oauthVersion = OAuthVersion.V1a;
    private String _refreshTokenEndpoint = "";
    private String _requestTokenEndpoint = "";
    private String _requestTypeForAccessToken;
    private String _requestTypeForAuthorizationUrl;
    private String _requestTypeForRequestToken;
    private boolean _useSSLHost = false;
    private boolean _useSSLHostUserModified = false;
    private boolean _useClientAuthorizationHeader = false;

    GenericOAuthAuthenticator() {
    }

    GenericOAuthAuthenticator(OAuthAuthenticator oauth) {
        this._accessTokenEndpoint = oauth.getAccessTokenEndpoint();
        this._accessTokenInput = oauth.getAccessTokenInput();
        this._accessTokenPublicKey = oauth.getAccessTokenPublicKey();
        this._appKey = oauth.getAppKey();
        this._appSecret = oauth.getAppSecret();
        this._authorizationUrl = oauth.getAuthorizationUrl();
        this._callbackPort = oauth.getCallbackPort();
        this._callbackPortUserModified = oauth.isCallbackPortUserModified();
        this._description = oauth.getDescription();
        this._displayName = oauth.getDisplayName();
        this._icon = oauth.getIcon();
        this._name = oauth.getName();
        this._oauthVersion = oauth.getOAuthVersion();
        this._refreshTokenEndpoint = oauth.getRefreshTokenEndpoint();
        this._requestTokenEndpoint = oauth.getRequestTokenEndpoint();
        this._requestTypeForAccessToken = oauth.getRequestTypeForAccessToken();
        this._requestTypeForAuthorizationUrl = oauth.getRequestTypeForAuthorizationUrl();
        this._requestTypeForRequestToken = oauth.getRequestTypeForRequestToken();
        this._useSSLHost = oauth.useSSLHost();
        this._useSSLHostUserModified = oauth.isUseSSLHostUserModified();
        this._useClientAuthorizationHeader = oauth.useClientAuthorizationHeader();
    }

    public boolean isCopyOf(OAuthAuthenticator other) {
        if (!Objects.equals(this._name, other.getName())) {
            return false;
        }
        if (!Objects.equals(this._displayName, other.getDisplayName())) {
            return false;
        }
        if (!Objects.equals(this._accessTokenEndpoint, other.getAccessTokenEndpoint())) {
            return false;
        }
        if (!Objects.equals(this._accessTokenInput, other.getAccessTokenInput())) {
            return false;
        }
        if (!Objects.equals(this._accessTokenPublicKey, other.getAccessTokenPublicKey())) {
            return false;
        }
        if (!Objects.equals(this._appKey, other.getAppKey())) {
            return false;
        }
        if (!Objects.equals(this._appSecret, other.getAppSecret())) {
            return false;
        }
        if (!Objects.equals(this._authorizationUrl, other.getAuthorizationUrl())) {
            return false;
        }
        if (!Objects.equals(this._description, other.getDescription())) {
            return false;
        }
        if (!Objects.equals(this._icon, other.getIcon())) {
            return false;
        }
        if (!Objects.equals(this._refreshTokenEndpoint, other.getRefreshTokenEndpoint())) {
            return false;
        }
        if (!Objects.equals(this._requestTokenEndpoint, other.getRequestTokenEndpoint())) {
            return false;
        }
        if (!Objects.equals(this._requestTypeForAccessToken, other.getRequestTypeForAccessToken())) {
            return false;
        }
        if (!Objects.equals(this._requestTypeForAuthorizationUrl, other.getRequestTypeForAuthorizationUrl())) {
            return false;
        }
        if (!Objects.equals(this._requestTypeForRequestToken, other.getRequestTypeForRequestToken())) {
            return false;
        }
        if (!Objects.equals(this._callbackPort, other.getCallbackPort())) {
            return false;
        }
        if (this._callbackPortUserModified != other.isCallbackPortUserModified()) {
            return false;
        }
        if (this._useSSLHost != other.useSSLHost()) {
            return false;
        }
        if (this._useSSLHostUserModified != other.isUseSSLHostUserModified()) {
            return false;
        }
        if (this._useClientAuthorizationHeader != other.useClientAuthorizationHeader()) {
            return false;
        }
        return this._oauthVersion == other.getOAuthVersion();
    }

    public String getAccessTokenEndpoint() {
        return this._accessTokenEndpoint;
    }

    public void setAccessTokenEndpoint(String accessTokenEndpoint) {
        this._accessTokenEndpoint = accessTokenEndpoint;
    }

    public String getAccessTokenInput() {
        return this._accessTokenInput;
    }

    public void setAccessTokenInput(String accessTokenInput) {
        this._accessTokenInput = accessTokenInput;
    }

    public String getAccessTokenPublicKey() {
        return this._accessTokenPublicKey;
    }

    public void setAccessTokenPublicKey(String accessTokenPublicKey) {
        this._accessTokenPublicKey = accessTokenPublicKey;
    }

    public String getAppKey() {
        return this._appKey;
    }

    public void setAppKey(String appKey) {
        this._appKey = appKey;
    }

    public String getAppSecret() {
        return this._appSecret;
    }

    public void setAppSecret(String appSecret) {
        this._appSecret = appSecret;
    }

    public String getAuthorizationUrl() {
        return this._authorizationUrl;
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this._authorizationUrl = authorizationUrl;
    }

    public Integer getCallbackPort() {
        return this._callbackPort;
    }

    public void setCallbackPort(Integer callbackPort) {
        this._callbackPort = callbackPort;
    }

    public boolean isCallbackPortUserModified() {
        return this._callbackPortUserModified;
    }

    public void setCallbackPortUserModified(boolean callbackPortUserModified) {
        this._callbackPortUserModified = callbackPortUserModified;
    }

    public OAuthAuthenticator setUserModifiedCallbackPort(Integer port) {
        GenericOAuthAuthenticator oauth = new GenericOAuthAuthenticator(this);
        oauth.setCallbackPort(port);
        oauth.setCallbackPortUserModified(true);
        return oauth;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getIcon() {
        return this._icon;
    }

    public void setIcon(String icon) {
        this._icon = icon;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public OAuthVersion getOAuthVersion() {
        return this._oauthVersion;
    }

    public void setOAuthVersion(OAuthVersion oauthVersion) {
        this._oauthVersion = oauthVersion;
    }

    public String getRefreshTokenEndpoint() {
        return this._refreshTokenEndpoint;
    }

    public void setRefreshTokenEndpoint(String refreshTokenEndpoint) {
        this._refreshTokenEndpoint = refreshTokenEndpoint;
    }

    public String getRequestTokenEndpoint() {
        return this._requestTokenEndpoint;
    }

    public void setRequestTokenEndpoint(String requestTokenEndpoint) {
        this._requestTokenEndpoint = requestTokenEndpoint;
    }

    public String getRequestTypeForAccessToken() {
        return this._requestTypeForAccessToken;
    }

    public void setRequestTypeForAccessToken(String requestTypeForAccessToken) {
        this._requestTypeForAccessToken = requestTypeForAccessToken;
    }

    public String getRequestTypeForAuthorizationUrl() {
        return this._requestTypeForAuthorizationUrl;
    }

    public void setRequestTypeForAuthorizationUrl(String requestTypeForAuthorizationUrl) {
        this._requestTypeForAuthorizationUrl = requestTypeForAuthorizationUrl;
    }

    public String getRequestTypeForRequestToken() {
        return this._requestTypeForRequestToken;
    }

    public void setRequestTypeForRequestToken(String requestTypeForRequestToken) {
        this._requestTypeForRequestToken = requestTypeForRequestToken;
    }

    public boolean useSSLHost() {
        return this._useSSLHost;
    }

    public void setUseSSLHost(boolean useSSLHost) {
        this._useSSLHost = useSSLHost;
    }

    public boolean isUseSSLHostUserModified() {
        return this._useSSLHostUserModified;
    }

    public void setUseSSLHostUserModified(boolean useSSLHostUserModified) {
        this._useSSLHostUserModified = useSSLHostUserModified;
    }

    public OAuthAuthenticator setUserModifiedUseSSLHost(boolean useSSLHost) {
        GenericOAuthAuthenticator oauth = new GenericOAuthAuthenticator(this);
        oauth.setUseSSLHost(useSSLHost);
        oauth.setUseSSLHostUserModified(true);
        return oauth;
    }

    public boolean useClientAuthorizationHeader() {
        return this._useClientAuthorizationHeader;
    }

    public void setUseClientAuthorizationHeader(boolean useClientAuthorizationHeader) {
        this._useClientAuthorizationHeader = useClientAuthorizationHeader;
    }

    public int hashCode() {
        int hash = 5;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.isCopyOf((GenericOAuthAuthenticator)obj);
    }

    public String toString() {
        return "GenericOAuthAuthenticator{\n      name=" + this._name + ",\n      displayName=" + this._displayName + ",\n      description=" + this._description + ",\n      oauthVersion=" + this._oauthVersion + ",\n      callbackPort=" + this._callbackPort + ",\n      callbackPortUserModified=" + this._callbackPortUserModified + ",\n      accessTokenEndpoint=" + this._accessTokenEndpoint + ",\n      refreshTokenEndpoint=" + this._refreshTokenEndpoint + ",\n      requestTokenEndpoint=" + this._requestTokenEndpoint + ",\n      requestTypeForAccessToken=" + this._requestTypeForAccessToken + ",\n      requestTypeForAuthorizationUrl=" + this._requestTypeForAuthorizationUrl + ",\n      requestTypeForRequestToken=" + this._requestTypeForRequestToken + ",\n      useSSLHost=" + this._useSSLHost + ",\n      useSSLHostUserModified=" + this._useSSLHostUserModified + ",\n      authorizationUrl=" + this._authorizationUrl + ",\n      appKey=" + this._appKey + ",\n      appSecret=" + this._appSecret + ",\n      icon=" + this._icon + ",\n      accessTokenInput=" + this._accessTokenInput + ",\n      accessTokenPublicKey=" + this._accessTokenPublicKey + "\n   }";
    }
}

