/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.AbstractHttpProtocolHandler;
import org.xlightweb.BadMessageException;
import org.xlightweb.ComposedByteBuffer;
import org.xlightweb.FullMessageBodyParser;
import org.xlightweb.FullMessageChunkedBodyParser;
import org.xlightweb.HttpRequest;
import org.xlightweb.HttpRequestHeader;
import org.xlightweb.HttpRequestHeaderParser;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.SimpleResponseMessageException;
import org.xsocket.connection.INonBlockingConnection;

final class HttpProtocolHandlerServerSide
extends AbstractHttpProtocolHandler {
    HttpProtocolHandlerServerSide() {
    }

    public void onData(AbstractHttpConnection httpConnection, INonBlockingConnection underlyingConnection, ComposedByteBuffer rawData) throws BadMessageException, IOException {
        try {
            switch (this.getState()) {
                case 0: {
                    this.setHeaderParser(HttpRequestHeaderParser.newInstance());
                    this.setState(5);
                    this.onData(httpConnection, underlyingConnection, rawData);
                    return;
                }
                case 5: {
                    HttpRequestHeader requestHeader = (HttpRequestHeader)this.getHeaderParser().parse(underlyingConnection, rawData);
                    if (requestHeader != null) {
                        httpConnection.setLastTimeHeaderReceivedMillis(System.currentTimeMillis());
                        httpConnection.incCountMessageReceived();
                        AbstractHttpConnection.IMessageHandler messageHandler = httpConnection.getMessageHandler();
                        if (messageHandler == null) {
                            throw new IOException("no message handler set");
                        }
                        HttpRequest request = null;
                        switch (HttpProtocolHandlerServerSide.getBodyType(requestHeader, messageHandler.isBodylessMessageExpected())) {
                            case 0: {
                                request = new HttpRequest(requestHeader);
                                this.reset();
                                break;
                            }
                            case 1: {
                                this.setBodyParser(new FullMessageBodyParser(httpConnection, requestHeader));
                                request = new HttpRequest((IHttpRequestHeader)requestHeader, this.getBodyParser().getDataSource());
                                this.setState(10);
                                request.getNonBlockingBody().setBodyDataReceiveTimeoutMillis(httpConnection.getBodyDataReceiveTimeoutMillis());
                                this.parserBody(rawData);
                                break;
                            }
                            default: {
                                this.setBodyParser(new FullMessageChunkedBodyParser(httpConnection, requestHeader));
                                request = new HttpRequest((IHttpRequestHeader)requestHeader, this.getBodyParser().getDataSource());
                                this.setState(10);
                                request.getNonBlockingBody().setBodyDataReceiveTimeoutMillis(httpConnection.getBodyDataReceiveTimeoutMillis());
                                this.parserBody(rawData);
                            }
                        }
                        messageHandler.onMessage(request);
                        return;
                    }
                    break;
                }
                default: {
                    this.parserBody(rawData);
                    break;
                }
            }
        }
        catch (BufferUnderflowException ignore) {
        }
        catch (SimpleResponseMessageException ignore) {
            // empty catch block
        }
    }

    private static int getBodyType(HttpRequestHeader requestHeader, boolean isBodylessMessageExcpected) throws BadMessageException {
        if (isBodylessMessageExcpected) {
            return 0;
        }
        String method = requestHeader.getMethod();
        if (method.equals("GET")) {
            return 0;
        }
        if (method.equals("POST")) {
            return HttpProtocolHandlerServerSide.getBodyTypeByHeader(requestHeader);
        }
        if (method.equals("CONNECT") || method.equals("HEAD") || method.equals("TRACE") || method.equals("DELETE") || method.equals("OPTIONS")) {
            return 0;
        }
        return HttpProtocolHandlerServerSide.getBodyTypeByHeader(requestHeader);
    }

    private static int getBodyTypeByHeader(HttpRequestHeader requestHeader) throws BadMessageException {
        if (requestHeader.getContentLength() != -1) {
            if (requestHeader.getContentLength() > 0) {
                return 1;
            }
            return 0;
        }
        String transferEncoding = requestHeader.getTransferEncoding();
        if (transferEncoding != null && transferEncoding.equalsIgnoreCase("chunked")) {
            return 2;
        }
        throw new BadMessageException(requestHeader.toString());
    }
}

