/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHeader;
import org.xlightweb.BlockingBodyDataSource;
import org.xlightweb.BodyType;
import org.xlightweb.IBodyDataHandler;
import org.xlightweb.IPart;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xsocket.Execution;

final class MultipartFormDataPart
extends AbstractHeader
implements IPart {
    private static final Logger LOG = Logger.getLogger(MultipartFormDataPart.class.getName());
    private final IPartReadListener partReadListener;
    private final String boundary;
    private final NonBlockingBodyDataSource partBodyDataSource;

    public MultipartFormDataPart(IPartReadListener partReadListener, String boundary, String[] headerlines, NonBlockingBodyDataSource messageBodyDataSource) throws IOException {
        this.partReadListener = partReadListener;
        this.boundary = boundary;
        String encoding = "ISO-8859-1";
        this.addHeaderlines(headerlines);
        this.partBodyDataSource = new NonBlockingBodyDataSource(BodyType.IN_MEMORY, encoding);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("new form data part body. set dataHandler to parse body (available=" + messageBodyDataSource.available() + ")");
        }
        MultipartFormDataHandler dh = new MultipartFormDataHandler();
        messageBodyDataSource.setDataHandler(dh);
        dh.onData(messageBodyDataSource);
    }

    public String getName() {
        return this.getDispositionParam("name");
    }

    public String getOriginalFilename() {
        return this.getDispositionParam("filename");
    }

    public void close() throws IOException {
        this.partBodyDataSource.close();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\r\n" + this.partBodyDataSource.toString());
        return sb.toString();
    }

    public BlockingBodyDataSource getBlockingBody() throws IOException {
        return new BlockingBodyDataSource(this.partBodyDataSource);
    }

    public NonBlockingBodyDataSource getNonBlockingBody() throws IOException {
        return this.partBodyDataSource;
    }

    public boolean hasBody() {
        return true;
    }

    public void destroy() {
        this.partBodyDataSource.destroy();
    }

    @Execution(value=0)
    private final class MultipartFormDataHandler
    implements IBodyDataHandler {
        private final String intermediateBoundary;
        private final String endBoundary;

        private MultipartFormDataHandler() {
            this.intermediateBoundary = "--" + MultipartFormDataPart.this.boundary + "\r\n";
            this.endBoundary = "\r\n--" + MultipartFormDataPart.this.boundary + "--\r\n";
        }

        public boolean onData(NonBlockingBodyDataSource bodyDataSource) throws BufferUnderflowException {
            block9: {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("parsing part body");
                }
                try {
                    if (MultipartFormDataPart.this.partBodyDataSource.isComplete()) {
                        return true;
                    }
                    int idx = bodyDataSource.indexOf(this.intermediateBoundary);
                    if (idx != -1) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("intermediateBoundary found at " + idx);
                        }
                        ByteBuffer[] data = bodyDataSource.readByteBufferByLength(idx);
                        MultipartFormDataPart.this.partBodyDataSource.append(true, data, null);
                        MultipartFormDataPart.this.partBodyDataSource.setComplete(true);
                        MultipartFormDataPart.this.partReadListener.onPartRead(MultipartFormDataPart.this);
                    } else {
                        idx = bodyDataSource.indexOf(this.endBoundary);
                        if (idx != -1) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("endBoundary found at " + idx);
                            }
                            ByteBuffer[] data = bodyDataSource.readByteBufferByLength(idx);
                            MultipartFormDataPart.this.partBodyDataSource.append(true, data, null);
                            bodyDataSource.readByteBufferByLength(this.endBoundary.length());
                            MultipartFormDataPart.this.partBodyDataSource.setComplete(true);
                            MultipartFormDataPart.this.partReadListener.onLastPartRead(MultipartFormDataPart.this);
                        }
                    }
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block9;
                    LOG.fine("error occured by parsing the part data " + ioe.toString());
                }
            }
            return true;
        }
    }

    static interface IPartReadListener {
        public void onPartRead(MultipartFormDataPart var1);

        public void onLastPartRead(MultipartFormDataPart var1);

        public void onException(IOException var1);
    }
}

