/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BodyDataSink;
import org.xlightweb.BodyType;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCloseListener;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IBodyDataHandler;
import org.xlightweb.ProtocolException;
import org.xlightweb.ReceiveTimeoutException;
import org.xlightweb.WriteCompletionManager;
import org.xsocket.DataConverter;
import org.xsocket.IDataSource;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.AbstractNonBlockingStream;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IWriteCompletionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NonBlockingBodyDataSource
implements IDataSource,
ReadableByteChannel,
Closeable {
    private static final Logger LOG = Logger.getLogger(NonBlockingBodyDataSource.class.getName());
    private static int maxWriteBufferSize = AbstractHttpConnection.getMaxWriteBufferSize();
    private final BodyType bodyType;
    private final NonBlockingStream nonBlockingStream = new NonBlockingStream();
    private final HandlerCaller handlerCaller = new HandlerCaller();
    private final AtomicBoolean isOpen = new AtomicBoolean(true);
    private final AtomicBoolean isDestroyed = new AtomicBoolean(false);
    private final AtomicBoolean isUnderlyingConnectionOpen = new AtomicBoolean(true);
    private static final long MIN_WATCHDOG_PERIOD_MILLIS = 10000L;
    public static final long DEFAULT_RECEIVE_TIMEOUT_MILLIS = Long.MAX_VALUE;
    private long bodyDataReceiveTimeoutMillis = Long.MAX_VALUE;
    private long creationTimeMillis = 0L;
    private long lastTimeDataReceivedMillis = System.currentTimeMillis();
    private TimeoutWatchDogTask watchDogTask;
    private boolean isDestroyConnectionAfterReceived = false;
    private boolean isCloseConnectionAfterReceived = false;
    private AtomicBoolean isOnDisconnectCalled = new AtomicBoolean(false);
    private final AbstractHttpConnection httpConnection;
    private final ArrayList<IBodyCloseListener> closeListeners = new ArrayList();
    private final ArrayList<IBodyCompleteListener> completeListeners = new ArrayList();
    private final AtomicBoolean isComplete = new AtomicBoolean(false);
    private final AtomicReference<IBodyDataSourceDisconnectHandler> disconnectHandler = new AtomicReference<Object>(null);
    private final AtomicReference<IBodyDataHandler> handler = new AtomicReference<Object>(null);
    private final AtomicBoolean isMultithreaded = new AtomicBoolean(true);
    private boolean isSystem = false;
    private final AtomicBoolean isSuspended = new AtomicBoolean(false);
    private final AtomicReference<IExceptionHandler> exceptionHandler = new AtomicReference<Object>(null);
    private final AtomicReference<IOException> exceptionHolder = new AtomicReference();
    private final AbstractHttpConnection.IMultimodeExecutor executor;
    private final AtomicBoolean isCompletionSupportActivated = new AtomicBoolean(false);
    private final WriteCompletionManager writeCompletionManager = new WriteCompletionManager(this.getId());

    NonBlockingBodyDataSource(BodyType bodyType, String encoding) {
        this.bodyType = bodyType;
        this.httpConnection = null;
        this.executor = new DefaultMultimodeExecutor();
        this.nonBlockingStream.setEncoding(encoding);
    }

    NonBlockingBodyDataSource(BodyType bodyType, String encoding, AbstractHttpConnection httpConnection, AbstractHttpConnection.IMultimodeExecutor executor) {
        this.bodyType = bodyType;
        this.executor = executor;
        this.nonBlockingStream.setEncoding(encoding);
        this.httpConnection = httpConnection;
    }

    NonBlockingBodyDataSource(BodyType bodyType, String body, String encoding) {
        this(bodyType, new ByteBuffer[]{DataConverter.toByteBuffer((String)body, (String)encoding)}, encoding);
    }

    NonBlockingBodyDataSource(BodyType bodyType, byte[] body, String encoding) {
        this(bodyType, new ByteBuffer[]{ByteBuffer.wrap(body)}, encoding);
    }

    NonBlockingBodyDataSource(BodyType bodyType, ByteBuffer[] body, String encoding) {
        this.bodyType = bodyType;
        this.httpConnection = null;
        this.executor = new DefaultMultimodeExecutor();
        if (encoding != null) {
            this.nonBlockingStream.setEncoding(encoding);
        }
        this.nonBlockingStream.append(body, null);
        this.isComplete.set(true);
    }

    NonBlockingBodyDataSource(BodyType bodyType, ReadableByteChannel bodyDatasource, String encoding) throws IOException {
        this(bodyType, bodyDatasource, 8192, encoding);
    }

    NonBlockingBodyDataSource(FileChannel bodyDatasource, String encoding) throws IOException {
        this(BodyType.IN_MEMORY, bodyDatasource, (int)bodyDatasource.size(), encoding);
    }

    private NonBlockingBodyDataSource(BodyType bodyType, ReadableByteChannel bodyDatasource, int chunkSize, String encoding) throws IOException {
        this.bodyType = bodyType;
        this.httpConnection = null;
        this.executor = new DefaultMultimodeExecutor();
        this.setEncoding(encoding);
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        int read = 0;
        do {
            ByteBuffer transferBuffer;
            if ((read = bodyDatasource.read(transferBuffer = ByteBuffer.allocate(chunkSize))) <= 0) continue;
            if (transferBuffer.remaining() == 0) {
                transferBuffer.flip();
                buffers.add(transferBuffer);
                continue;
            }
            transferBuffer.flip();
            buffers.add(transferBuffer.slice());
        } while (read > 0);
        this.nonBlockingStream.append(buffers.toArray(new ByteBuffer[buffers.size()]), null);
        this.isComplete.set(true);
    }

    void setEncoding(String encoding) {
        this.nonBlockingStream.setEncoding(encoding);
    }

    String getId() {
        if (this.httpConnection != null) {
            return this.httpConnection.getId();
        }
        return Integer.toString(this.hashCode());
    }

    AbstractHttpConnection getConnection() {
        return this.httpConnection;
    }

    ByteBuffer[] copyContent() {
        return this.nonBlockingStream.copyContent();
    }

    void destroy() {
        this.isDestroyed.set(true);
        if (this.httpConnection != null) {
            this.httpConnection.destroy();
        }
    }

    void setDestroyAfterReceived(boolean isDestroyConnectionAfterReceived) {
        this.isDestroyConnectionAfterReceived = isDestroyConnectionAfterReceived;
        if (this.isComplete.get()) {
            this.handleReceivingFinished();
        }
    }

    void setCloseAfterReceived(boolean isCloseConnectionAfterReceived) {
        this.isCloseConnectionAfterReceived = isCloseConnectionAfterReceived;
        if (this.isComplete.get()) {
            this.handleReceivingFinished();
        }
    }

    private void suspend() throws IOException {
        boolean suspended;
        if (this.httpConnection != null && !this.httpConnection.isReceivingSuspended() && !(suspended = this.isSuspended.getAndSet(true))) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("suspend receiving data");
            }
            this.isSuspended.set(true);
            Runnable suspendTask = new Runnable(){

                public void run() {
                    block2: {
                        try {
                            NonBlockingBodyDataSource.this.httpConnection.suspendReceiving();
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block2;
                            LOG.fine("error occured by resuming " + NonBlockingBodyDataSource.this + " " + ioe.toString());
                        }
                    }
                }
            };
            this.executor.processNonthreaded(suspendTask);
        }
    }

    private void resume() throws IOException {
        boolean suspended;
        if (this.httpConnection != null && (suspended = this.isSuspended.getAndSet(false))) {
            Runnable resumeTask = new Runnable(){

                public void run() {
                    block4: {
                        try {
                            if (NonBlockingBodyDataSource.this.httpConnection.isReceivingSuspended()) {
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.fine("resume receiving data");
                                }
                                NonBlockingBodyDataSource.this.httpConnection.resumeReceiving();
                                NonBlockingBodyDataSource.this.callBodyHandler(true, true);
                            }
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block4;
                            LOG.fine("error occured by resuming " + NonBlockingBodyDataSource.this + " " + ioe.toString());
                        }
                    }
                }
            };
            this.executor.processNonthreaded(resumeTask);
        }
    }

    void onDisconnect() {
        if (this.isOnDisconnectCalled.getAndSet(true)) {
            return;
        }
        if (LOG.isLoggable(Level.FINE) && !this.isComplete.get()) {
            LOG.fine("protocol error occured (connection is closed, but more data is expected). May be connection has been closed by peer?");
        }
        this.isUnderlyingConnectionOpen.set(false);
        this.callBodyHandler(true, false);
        IBodyDataSourceDisconnectHandler dh = this.disconnectHandler.get();
        if (dh != null) {
            OnDisconnectCaller task = new OnDisconnectCaller(dh);
            this.processNonthreaded(task);
        }
    }

    BodyType getBodyType() {
        return this.bodyType;
    }

    public long getBodyDataReceiveTimeoutMillis() {
        return this.bodyDataReceiveTimeoutMillis;
    }

    public void setBodyDataReceiveTimeoutMillis(long bodyDataReceiveTimeoutMillis) {
        if (bodyDataReceiveTimeoutMillis <= 0L) {
            if (!this.isComplete.get()) {
                this.setIOException(new ReceiveTimeoutException(bodyDataReceiveTimeoutMillis));
            }
            return;
        }
        this.creationTimeMillis = System.currentTimeMillis();
        if (this.bodyDataReceiveTimeoutMillis != bodyDataReceiveTimeoutMillis) {
            this.bodyDataReceiveTimeoutMillis = bodyDataReceiveTimeoutMillis;
            if (bodyDataReceiveTimeoutMillis == Long.MAX_VALUE) {
                this.terminateWatchDog();
            } else {
                long watchdogPeriod = 100L;
                if (bodyDataReceiveTimeoutMillis > 1000L) {
                    watchdogPeriod = bodyDataReceiveTimeoutMillis / 10L;
                }
                if (watchdogPeriod > 10000L) {
                    watchdogPeriod = 10000L;
                }
                this.updateWatchDog(watchdogPeriod);
            }
        }
    }

    private synchronized void updateWatchDog(long watchDogPeriod) {
        this.terminateWatchDog();
        this.watchDogTask = new TimeoutWatchDogTask(this);
        AbstractHttpConnection.schedule(this.watchDogTask, watchDogPeriod, watchDogPeriod);
    }

    private synchronized void terminateWatchDog() {
        if (this.watchDogTask != null) {
            this.watchDogTask.cancel();
            this.watchDogTask = null;
        }
    }

    private void checkTimeouts() {
        if (this.isComplete.get()) {
            this.terminateWatchDog();
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis > this.lastTimeDataReceivedMillis + this.bodyDataReceiveTimeoutMillis && currentTimeMillis > this.creationTimeMillis + this.bodyDataReceiveTimeoutMillis) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("receive timeout reached. set exception");
            }
            if (!this.isComplete.get()) {
                this.setIOException(new ReceiveTimeoutException());
            }
            this.destroy();
        }
    }

    void setExceptionHandler(IExceptionHandler eh) {
        this.exceptionHandler.set(eh);
    }

    void setIOException(IOException ioe) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("error occured " + ioe.toString());
        }
        if (this.exceptionHolder.get() == null) {
            IExceptionHandler eh = this.exceptionHandler.get();
            if (eh != null) {
                eh.onException(ioe);
            }
            this.exceptionHolder.set(ioe);
        }
        this.closeUnclean();
    }

    private void throwExceptionIfExist() throws IOException {
        if (this.exceptionHolder.get() != null) {
            IOException ex = this.exceptionHolder.get();
            this.exceptionHolder.set(null);
            throw ex;
        }
    }

    String getEncoding() {
        return this.nonBlockingStream.getEncoding();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen.get();
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    private void close(boolean isSetComplete) throws IOException {
        if (!this.isComplete.get() && this.httpConnection != null) {
            this.httpConnection.setPersistent(false);
        }
        if (isSetComplete) {
            this.isComplete.set(true);
        }
        this.terminateWatchDog();
        this.nonBlockingStream.close();
        this.callBodyHandler(true, false);
        this.handleReceivingFinished();
        this.callCloseListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callCloseListener() {
        ArrayList closeListenersCopy = null;
        ArrayList<IBodyCloseListener> arrayList = this.closeListeners;
        synchronized (arrayList) {
            closeListenersCopy = (ArrayList)this.closeListeners.clone();
        }
        for (IBodyCloseListener bodyCloseListener : closeListenersCopy) {
            this.removeCloseListener(bodyCloseListener);
            this.callCloseListener(bodyCloseListener);
        }
    }

    private void callCloseListener(IBodyCloseListener listener) {
        BodyCloselistenerCaller task = new BodyCloselistenerCaller(listener);
        if (HttpUtils.isBodyCloseListenerMutlithreaded(listener)) {
            this.executor.processMultithreaded(task);
        } else {
            this.executor.processNonthreaded(task);
        }
    }

    private int getSize() throws IOException {
        return this.nonBlockingStream.available();
    }

    public int available() throws ProtocolException, IOException {
        int available;
        if (this.exceptionHolder.get() != null) {
            IOException ex = this.exceptionHolder.get();
            this.exceptionHolder.set(null);
            if (!(ex instanceof ClosedChannelException)) {
                throw ex;
            }
        }
        if ((available = this.nonBlockingStream.getSize()) == 0) {
            if (this.isComplete.get()) {
                return -1;
            }
            if (this.isUnderlyingConnectionOpen.get()) {
                return 0;
            }
            this.isOpen.set(false);
            throw new ClosedChannelException();
        }
        return available;
    }

    int size() throws IOException {
        int available = this.nonBlockingStream.getSize();
        if (available <= 0 && this.isComplete.get()) {
            return -1;
        }
        return available;
    }

    private int getVersion() throws IOException {
        return this.nonBlockingStream.getReadBufferVersion();
    }

    public int getReadBufferVersion() throws IOException {
        this.throwExceptionIfExist();
        return this.nonBlockingStream.getReadBufferVersion();
    }

    public void markReadPosition() {
        this.nonBlockingStream.markReadPosition();
    }

    public boolean resetToReadMark() {
        return this.nonBlockingStream.resetToReadMark();
    }

    public void removeReadMark() {
        this.nonBlockingStream.removeReadMark();
    }

    public int indexOf(String str) throws IOException {
        this.throwExceptionIfExist();
        return this.nonBlockingStream.indexOf(str);
    }

    public int indexOf(String str, String encoding) throws IOException, MaxReadSizeExceededException {
        this.throwExceptionIfExist();
        return this.nonBlockingStream.indexOf(str, encoding);
    }

    public byte readByte() throws ProtocolException, IOException, BufferUnderflowException {
        this.throwExceptionIfExist();
        return this.nonBlockingStream.readByte();
    }

    public short readShort() throws ProtocolException, IOException, BufferUnderflowException {
        this.throwExceptionIfExist();
        return this.nonBlockingStream.readShort();
    }

    public int readInt() throws ProtocolException, IOException, BufferUnderflowException {
        this.throwExceptionIfExist();
        return this.nonBlockingStream.readInt();
    }

    public long readLong() throws IOException, BufferUnderflowException {
        this.throwExceptionIfExist();
        return this.nonBlockingStream.readLong();
    }

    public double readDouble() throws ProtocolException, IOException, BufferUnderflowException {
        this.throwExceptionIfExist();
        return this.nonBlockingStream.readDouble();
    }

    @Override
    public int read(ByteBuffer buffer) throws ProtocolException, IOException {
        this.throwExceptionIfExist();
        int size = buffer.remaining();
        int available = this.available();
        if (available == -1) {
            this.close();
            return -1;
        }
        if (available == 0) {
            return 0;
        }
        if (available > 0) {
            if (available < size) {
                size = available;
            }
            if (size > 0) {
                ByteBuffer[] bufs = this.readByteBufferByLength(size);
                this.copyBuffers(bufs, buffer);
            }
        }
        return size;
    }

    private void copyBuffers(ByteBuffer[] source, ByteBuffer target) {
        for (ByteBuffer buf : source) {
            if (!buf.hasRemaining()) continue;
            target.put(buf);
        }
    }

    public ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws ProtocolException, IOException, BufferUnderflowException {
        return this.readByteBufferByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws ProtocolException, IOException, BufferUnderflowException, MaxReadSizeExceededException {
        this.throwExceptionIfExist();
        return this.nonBlockingStream.readByteBufferByDelimiter(delimiter, maxLength);
    }

    public ByteBuffer[] readByteBufferByLength(int length) throws IOException, BufferUnderflowException {
        this.throwExceptionIfExist();
        ByteBuffer[] bufs = this.nonBlockingStream.readByteBufferByLength(length);
        if (LOG.isLoggable(Level.FINE)) {
            int size = 0;
            for (ByteBuffer buffer : bufs) {
                size += buffer.remaining();
            }
            LOG.fine(size + " data read (remaining " + this.nonBlockingStream.getSize() + ")");
        }
        return bufs;
    }

    public byte[] readBytesByDelimiter(String delimiter) throws ProtocolException, IOException, BufferUnderflowException {
        return DataConverter.toBytes((ByteBuffer[])this.readByteBufferByDelimiter(delimiter));
    }

    public byte[] readBytesByDelimiter(String delimiter, int maxLength) throws ProtocolException, IOException, BufferUnderflowException, MaxReadSizeExceededException {
        return DataConverter.toBytes((ByteBuffer[])this.readByteBufferByDelimiter(delimiter, maxLength));
    }

    public byte[] readBytesByLength(int length) throws ProtocolException, IOException, BufferUnderflowException {
        return DataConverter.toBytes((ByteBuffer[])this.readByteBufferByLength(length));
    }

    public String readStringByDelimiter(String delimiter) throws ProtocolException, IOException, BufferUnderflowException, UnsupportedEncodingException {
        return DataConverter.toString((ByteBuffer[])this.readByteBufferByDelimiter(delimiter), (String)this.getEncoding());
    }

    public String readStringByDelimiter(String delimiter, int maxLength) throws ProtocolException, IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
        return DataConverter.toString((ByteBuffer[])this.readByteBufferByDelimiter(delimiter, maxLength), (String)this.getEncoding());
    }

    public String readStringByLength(int length) throws ProtocolException, IOException, BufferUnderflowException, UnsupportedEncodingException {
        return DataConverter.toString((ByteBuffer[])this.readByteBufferByLength(length), (String)this.getEncoding());
    }

    public long transferTo(WritableByteChannel dataSink, int length) throws ProtocolException, IOException, ClosedChannelException {
        this.throwExceptionIfExist();
        if (length > 0) {
            ByteBuffer[] buffers;
            long written = 0L;
            for (ByteBuffer buffer : buffers = this.readByteBufferByLength(length)) {
                while (buffer.hasRemaining()) {
                    written += (long)dataSink.write(buffer);
                }
            }
            return written;
        }
        return 0L;
    }

    public long transferTo(BodyDataSink dataSink) throws ProtocolException, IOException, ClosedChannelException {
        return this.transferTo(dataSink, this.available());
    }

    public long transferTo(final BodyDataSink dataSink, int length) throws ProtocolException, IOException, ClosedChannelException {
        this.throwExceptionIfExist();
        long written = 0L;
        if (length > 0) {
            boolean savedAutoflush = dataSink.isAutoflush();
            dataSink.setAutoflush(true);
            if (dataSink.getFlushmode() == IConnection.FlushMode.ASYNC) {
                final ByteBuffer[] bufs = this.nonBlockingStream.readByteBufferByLength(length);
                IWriteCompletionHandler adapter = new IWriteCompletionHandler(){

                    public void onWritten(int length) throws IOException {
                        NonBlockingBodyDataSource.this.flowControlOnWritten(dataSink);
                        NonBlockingBodyDataSource.this.writeCompletionManager.onWritten(bufs, true);
                    }

                    public void onException(IOException ioe) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("error occured by writing " + ioe.toString());
                        }
                        NonBlockingBodyDataSource.this.flowControlOnWritten(dataSink);
                        NonBlockingBodyDataSource.this.writeCompletionManager.onWriteException(ioe, bufs);
                        NonBlockingBodyDataSource.this.destroy();
                    }
                };
                this.flowControlOnWrite(dataSink, adapter);
                dataSink.write(bufs, adapter);
                written = length;
            } else {
                written = this.transferTo((WritableByteChannel)dataSink, length);
            }
            dataSink.setAutoflush(savedAutoflush);
        }
        return written;
    }

    private void flowControlOnWrite(BodyDataSink dataSink, IWriteCompletionHandler adapter) throws IOException {
        if (dataSink.isNetworkEndpoint() && maxWriteBufferSize != Integer.MAX_VALUE && dataSink.getPendingWriteDataSize() > maxWriteBufferSize) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("pending write buffer " + dataSink.getPendingWriteDataSize() + " is larger than max size " + maxWriteBufferSize + ". suspend receving");
            }
            this.suspend();
        }
    }

    private void flowControlOnWritten(BodyDataSink dataSink) {
        block3: {
            if (maxWriteBufferSize != Integer.MAX_VALUE && dataSink.getPendingWriteDataSize() > maxWriteBufferSize) {
                return;
            }
            try {
                this.resume();
            }
            catch (IOException e) {
                if (!LOG.isLoggable(Level.FINE)) break block3;
                LOG.fine("error occured by resume receving " + this + " " + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompleteListener(IBodyCompleteListener listener) {
        ArrayList<IBodyCompleteListener> arrayList = this.completeListeners;
        synchronized (arrayList) {
            this.completeListeners.add(listener);
        }
        if (this.isComplete.get()) {
            this.callCompleteListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeCompleteListener(IBodyCompleteListener listener) {
        ArrayList<IBodyCompleteListener> arrayList = this.completeListeners;
        synchronized (arrayList) {
            return this.completeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCloseListener(IBodyCloseListener closeListener) {
        ArrayList<IBodyCloseListener> arrayList = this.closeListeners;
        synchronized (arrayList) {
            this.closeListeners.add(closeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeCloseListener(IBodyCloseListener closeListener) {
        ArrayList<IBodyCloseListener> arrayList = this.closeListeners;
        synchronized (arrayList) {
            return this.closeListeners.remove(closeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<IBodyCompleteListener> replaceCompleteListener(IBodyCompleteListener listener) {
        List oldCompleteListeners = null;
        ArrayList<IBodyCompleteListener> arrayList = this.completeListeners;
        synchronized (arrayList) {
            oldCompleteListeners = (List)this.completeListeners.clone();
            this.completeListeners.clear();
            this.completeListeners.add(listener);
        }
        return oldCompleteListeners;
    }

    void setComplete(boolean isComplete) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] complete message received");
        }
        if (isComplete) {
            this.terminateWatchDog();
            this.isComplete.set(isComplete);
            this.callBodyHandler(true, false);
            this.callCompleteListeners();
            this.handleReceivingFinished();
        }
    }

    private void handleReceivingFinished() {
        if (this.isDestroyConnectionAfterReceived && this.httpConnection != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] auto destroying connection");
            }
            this.httpConnection.destroy();
        }
        if (this.isCloseConnectionAfterReceived && this.httpConnection != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] auto closing connection");
            }
            this.httpConnection.closeSilence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callCompleteListeners() {
        List completeListenersCopy = null;
        ArrayList<IBodyCompleteListener> arrayList = this.completeListeners;
        synchronized (arrayList) {
            if (!this.completeListeners.isEmpty()) {
                completeListenersCopy = (List)this.completeListeners.clone();
            }
        }
        if (completeListenersCopy != null) {
            for (IBodyCompleteListener listener : completeListenersCopy) {
                this.removeCompleteListener(listener);
                this.callCompleteListener(listener);
            }
        }
    }

    private void callCompleteListener(IBodyCompleteListener listener) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("call complete listener " + listener);
        }
        CompleteListenerCaller task = new CompleteListenerCaller(listener);
        if (HttpUtils.isBodyCompleteListenerMutlithreaded(listener)) {
            this.executor.processMultithreaded(task);
        } else {
            this.executor.processNonthreaded(task);
        }
    }

    void processMultithreaded(Runnable task) {
        this.executor.processMultithreaded(task);
    }

    void processNonthreaded(Runnable task) {
        this.executor.processNonthreaded(task);
    }

    boolean isComplete() throws IOException {
        this.throwExceptionIfExist();
        return this.isComplete.get();
    }

    void setDisconnectHandler(IBodyDataSourceDisconnectHandler dh) {
        this.disconnectHandler.set(dh);
    }

    void setSystemDataHandler(IBodyDataHandler bodyHandler) throws IOException {
        this.isSystem = true;
        this.setDataHandler(bodyHandler);
    }

    public IBodyDataHandler getDataHandler() {
        return this.handler.get();
    }

    public void setDataHandler(IBodyDataHandler bodyHandler) {
        if (bodyHandler == null) {
            this.handler.set(null);
        } else {
            this.isMultithreaded.set(HttpUtils.isMutlithreaded(bodyHandler));
            this.handler.set(bodyHandler);
            this.callBodyHandler(false, false);
        }
    }

    IBodyDataHandler replaceDataHandler(IBodyDataHandler bodyHandler) {
        if (bodyHandler == null) {
            return this.handler.getAndSet(null);
        }
        this.isMultithreaded.set(HttpUtils.isMutlithreaded(bodyHandler));
        IBodyDataHandler bdh = this.handler.getAndSet(bodyHandler);
        this.callBodyHandler(false, false);
        return bdh;
    }

    void append(boolean isContentImmutable, ByteBuffer data) throws IOException {
        this.preAppend();
        if (!isContentImmutable) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("buffer to append is mutable. coping it");
            }
            data = HttpUtils.copy(data);
        }
        if (data != null) {
            this.nonBlockingStream.append(data);
        }
        this.callBodyHandler(false, false);
    }

    void append(boolean isContentImmutable, ByteBuffer[] data, IWriteCompletionHandler completionHandler) throws IOException {
        this.preAppend();
        if (!isContentImmutable) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("buffer to append is mutable. coping it");
            }
            data = HttpUtils.copy(data);
        }
        if (data != null) {
            this.nonBlockingStream.append(data, completionHandler);
        }
        this.callBodyHandler(false, false);
    }

    private void preAppend() throws IOException {
        this.lastTimeDataReceivedMillis = System.currentTimeMillis();
        if (!this.isOpen.get() || this.isDestroyed.get()) {
            throw new ClosedChannelException();
        }
    }

    private void callBodyHandler(boolean forceCall, boolean forceMultithreaded) {
        if (this.handler.get() != null) {
            this.handlerCaller.setForceCall(forceCall);
            if (this.httpConnection == null || this.isSystem) {
                this.performCallLoop(forceCall);
            } else if (forceMultithreaded || this.isMultithreaded.get()) {
                this.executor.processMultithreaded(this.handlerCaller);
            } else {
                this.executor.processNonthreaded(this.handlerCaller);
            }
        }
    }

    private void performCallLoop(boolean forceCall) {
        block5: {
            try {
                while (this.getSize() != 0 || forceCall) {
                    int version = this.getVersion();
                    boolean success = this.call();
                    if (!success) {
                        return;
                    }
                    if (version != this.getVersion()) continue;
                    return;
                }
            }
            catch (BufferUnderflowException bue) {
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.fine("error occured by performing handler call " + ioe.toString());
            }
        }
    }

    private boolean call() {
        try {
            IBodyDataHandler bdh = this.handler.get();
            if (bdh != null) {
                return bdh.onData(this);
            }
            return false;
        }
        catch (BufferUnderflowException ignore) {
        }
        catch (RuntimeException re) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("closing data source because an error has been occured by handling data by bodyHandler. " + this.handler + " Reason: " + re.toString());
            }
            this.closeUnclean();
            throw re;
        }
        return false;
    }

    int getWriteTransferChunkeSize() {
        return this.nonBlockingStream.getWriteTransferChunkeSize();
    }

    private void closeUnclean() {
        block2: {
            try {
                this.close(false);
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("Error occured by closing data source " + this + " " + ioe.toString());
            }
        }
    }

    boolean isMoreInputDataExpected() {
        if (this.isComplete.get()) {
            return false;
        }
        return this.isUnderlyingConnectionOpen.get();
    }

    public String toString() {
        try {
            return this.nonBlockingStream.toString();
        }
        catch (Exception e) {
            return "error occured by performing toString: " + DataConverter.toString((Throwable)e);
        }
    }

    static interface IBodyDataSourceDisconnectHandler {
        public void onDisconnect();
    }

    static interface IExceptionHandler {
        public void onException(IOException var1);
    }

    private static class DefaultMultimodeExecutor
    implements AbstractHttpConnection.IMultimodeExecutor {
        private static final Executor defaultExecutor = Executors.newCachedThreadPool();

        private DefaultMultimodeExecutor() {
        }

        public void processMultithreaded(Runnable task) {
            defaultExecutor.execute(task);
        }

        public void processNonthreaded(Runnable task) {
            task.run();
        }
    }

    private static final class TimeoutWatchDogTask
    extends TimerTask {
        private WeakReference<NonBlockingBodyDataSource> dataSourceRef = null;

        public TimeoutWatchDogTask(NonBlockingBodyDataSource dataSource) {
            this.dataSourceRef = new WeakReference<NonBlockingBodyDataSource>(dataSource);
        }

        public void run() {
            block4: {
                try {
                    NonBlockingBodyDataSource dataSource = (NonBlockingBodyDataSource)this.dataSourceRef.get();
                    if (dataSource == null) {
                        this.cancel();
                    } else {
                        dataSource.checkTimeouts();
                    }
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine("error occured by checking timeouts " + e.toString());
                }
            }
        }
    }

    private final class NonBlockingStream
    extends AbstractNonBlockingStream {
        private NonBlockingStream() {
        }

        private void append(ByteBuffer buffer) {
            this.appendDataToReadBuffer(new ByteBuffer[]{buffer}, buffer.remaining());
        }

        private void append(ByteBuffer[] buffers, IWriteCompletionHandler completionHandler) {
            if (completionHandler != null) {
                NonBlockingBodyDataSource.this.isCompletionSupportActivated.set(true);
                NonBlockingBodyDataSource.this.writeCompletionManager.registerCompletionHandler(completionHandler, NonBlockingBodyDataSource.this.executor, buffers);
            }
            int size = 0;
            for (ByteBuffer byteBuffer : buffers) {
                size += byteBuffer.remaining();
            }
            this.appendDataToReadBuffer(buffers, size);
        }

        int getSize() {
            return this.getReadQueueSize();
        }

        ByteBuffer[] copyContent() {
            return super.copyReadQueue();
        }

        protected ByteBuffer[] onRead(ByteBuffer[] readBufs) throws IOException {
            block3: {
                if (NonBlockingBodyDataSource.this.getSize() == 0 && NonBlockingBodyDataSource.this.isComplete.get()) {
                    try {
                        NonBlockingBodyDataSource.this.close();
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block3;
                        LOG.fine("error occured by closing body data source " + ioe.toString());
                    }
                }
            }
            return readBufs;
        }

        public void close() throws IOException {
            super.close();
            if (NonBlockingBodyDataSource.this.isOpen.get()) {
                NonBlockingBodyDataSource.this.terminateWatchDog();
            }
            NonBlockingBodyDataSource.this.isOpen.set(false);
        }

        protected boolean isDataWriteable() {
            return NonBlockingBodyDataSource.this.isOpen.get();
        }

        protected boolean isMoreInputDataExpected() {
            return NonBlockingBodyDataSource.this.isMoreInputDataExpected();
        }

        public boolean isOpen() {
            return NonBlockingBodyDataSource.this.isOpen();
        }

        protected int getWriteTransferChunkeSize() {
            if (NonBlockingBodyDataSource.this.httpConnection != null) {
                try {
                    return (Integer)NonBlockingBodyDataSource.this.httpConnection.getOption("SOL_SOCKET.SO_SNDBUF");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return super.getWriteTransferChunkeSize();
        }

        public String toString() {
            return this.printReadBuffer(NonBlockingBodyDataSource.this.getEncoding());
        }
    }

    final class HandlerCaller
    implements Runnable {
        private boolean forceCall = false;

        HandlerCaller() {
        }

        private void setForceCall(boolean forceCall) {
            this.forceCall = forceCall;
        }

        public void run() {
            NonBlockingBodyDataSource.this.performCallLoop(this.forceCall);
        }
    }

    private static final class CompleteListenerCaller
    implements Runnable {
        private IBodyCompleteListener listener = null;

        public CompleteListenerCaller(IBodyCompleteListener listener) {
            this.listener = listener;
        }

        public void run() {
            block2: {
                try {
                    this.listener.onComplete();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("Error occured by calling complete listener " + this.listener + " " + ioe.toString());
                }
            }
        }
    }

    private static final class BodyCloselistenerCaller
    implements Runnable {
        private IBodyCloseListener listener = null;

        public BodyCloselistenerCaller(IBodyCloseListener listener) {
            this.listener = listener;
        }

        public void run() {
            block2: {
                try {
                    this.listener.onClose();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("Error occured by calling close listener " + this.listener + " " + ioe.toString());
                }
            }
        }
    }

    private static final class OnDisconnectCaller
    implements Runnable {
        private IBodyDataSourceDisconnectHandler dh = null;

        public OnDisconnectCaller(IBodyDataSourceDisconnectHandler dh) {
            this.dh = dh;
        }

        public void run() {
            this.dh.onDisconnect();
        }
    }
}

