/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.parser;

import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.HandlerBase;
import com.steadystate.css.parser.LexicalUnitImpl;
import java.io.FileReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.helpers.ParserFactory;

public class ParseTest
extends HandlerBase {
    private static final String PARSER = "com.steadystate.css.parser.SACParser";
    private int _propertyCounter = 0;
    private int _indentSize = 0;

    public ParseTest() {
        try {
            CSSOMParser.setProperty("org.w3c.css.sac.parser", PARSER);
            ParserFactory factory = new ParserFactory();
            Parser parser = factory.makeParser();
            parser.setDocumentHandler(this);
            FileReader r = new FileReader("c:\\working\\css2parser\\stylesheets\\page_test.css");
            InputSource is = new InputSource(r);
            parser.parseStyleSheet(is);
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        new ParseTest();
    }

    @Override
    public void startDocument(InputSource source) throws CSSException {
        System.out.println("startDocument");
    }

    @Override
    public void endDocument(InputSource source) throws CSSException {
        System.out.println("endDocument");
    }

    @Override
    public void comment(String text) throws CSSException {
    }

    @Override
    public void ignorableAtRule(String atRule) throws CSSException {
        System.out.println(atRule);
    }

    @Override
    public void namespaceDeclaration(String prefix, String uri) throws CSSException {
    }

    @Override
    public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
        System.out.print("@import url(" + uri + ")");
        if (media.getLength() > 0) {
            System.out.println(" " + media.toString() + ";");
        } else {
            System.out.println(";");
        }
    }

    @Override
    public void startMedia(SACMediaList media) throws CSSException {
        System.out.println(this.indent() + "@media " + media.toString() + " {");
        this.incIndent();
    }

    @Override
    public void endMedia(SACMediaList media) throws CSSException {
        this.decIndent();
        System.out.println(this.indent() + "}");
    }

    @Override
    public void startPage(String name, String pseudo_page) throws CSSException {
        System.out.print(this.indent() + "@page");
        if (name != null) {
            System.out.print(" " + name);
        }
        if (pseudo_page != null) {
            System.out.println(" " + pseudo_page);
        }
        System.out.println(" {");
        this._propertyCounter = 0;
        this.incIndent();
    }

    @Override
    public void endPage(String name, String pseudo_page) throws CSSException {
        System.out.println();
        this.decIndent();
        System.out.println(this.indent() + "}");
    }

    @Override
    public void startFontFace() throws CSSException {
        System.out.println(this.indent() + "@font-face {");
        this._propertyCounter = 0;
        this.incIndent();
    }

    @Override
    public void endFontFace() throws CSSException {
        System.out.println();
        this.decIndent();
        System.out.println(this.indent() + "}");
    }

    @Override
    public void startSelector(SelectorList selectors) throws CSSException {
        System.out.println(this.indent() + selectors.toString() + " {");
        this._propertyCounter = 0;
        this.incIndent();
    }

    @Override
    public void endSelector(SelectorList selectors) throws CSSException {
        System.out.println();
        this.decIndent();
        System.out.println(this.indent() + "}");
    }

    @Override
    public void property(String name, LexicalUnit value, boolean important) throws CSSException {
        if (this._propertyCounter++ > 0) {
            System.out.println(";");
        }
        System.out.print(this.indent() + name + ":");
        for (LexicalUnit nextVal = value; nextVal != null; nextVal = nextVal.getNextLexicalUnit()) {
            System.out.print(" " + ((LexicalUnitImpl)nextVal).toDebugString());
        }
        if (important) {
            System.out.print(" !important");
        }
    }

    private String indent() {
        StringBuffer sb = new StringBuffer(16);
        for (int i = 0; i < this._indentSize; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private void incIndent() {
        this._indentSize += 4;
    }

    private void decIndent() {
        this._indentSize -= 4;
    }
}

