/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.HTMLButtonElementImpl;
import org.lobobrowser.html.domimpl.HTMLInputElementImpl;
import org.lobobrowser.html.domimpl.HTMLLinkElementImpl;
import org.lobobrowser.html.domimpl.HTMLSelectElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.js.Event;
import org.lobobrowser.html.js.Executor;
import org.mozilla.javascript.Function;

class HtmlController {
    private static final Logger logger = Logger.getLogger(HtmlController.class.getName());
    private static final HtmlController instance = new HtmlController();

    HtmlController() {
    }

    static HtmlController getInstance() {
        return instance;
    }

    public boolean onEnterPressed(ModelNode node, InputEvent event) {
        HTMLInputElementImpl hie;
        if (node instanceof HTMLInputElementImpl && (hie = (HTMLInputElementImpl)node).isSubmittableWithEnterKey()) {
            hie.submitForm(null);
            return false;
        }
        return false;
    }

    public boolean onMouseClick(ModelNode node, MouseEvent event, int x, int y) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("onMouseClick(): node=" + node + ",class=" + node.getClass().getName());
        }
        if (node instanceof HTMLAbstractUIElement) {
            Event jsEvent;
            HTMLAbstractUIElement uiElement = (HTMLAbstractUIElement)node;
            Function f = uiElement.getOnclick();
            if (f != null && !Executor.executeFunction(uiElement, f, jsEvent = new Event("click", uiElement, event, x, y))) {
                return false;
            }
            HtmlRendererContext rcontext = uiElement.getHtmlRendererContext();
            if (rcontext != null && !rcontext.onMouseClick(uiElement, event)) {
                return false;
            }
        }
        if (node instanceof HTMLLinkElementImpl) {
            ((HTMLLinkElementImpl)node).navigate();
            return false;
        }
        if (node instanceof HTMLButtonElementImpl) {
            HTMLButtonElementImpl button = (HTMLButtonElementImpl)node;
            String rawType = button.getAttribute("type");
            String type = rawType == null ? "submit" : rawType.trim().toLowerCase();
            if ("submit".equals(type)) {
                String name = button.getName();
                FormInput[] formInputs = name == null ? null : new FormInput[]{new FormInput(name, button.getValue())};
                button.submitForm(formInputs);
            } else if ("reset".equals(type)) {
                button.resetForm();
            }
            return false;
        }
        ModelNode parent = node.getParentModelNode();
        if (parent == null) {
            return true;
        }
        return this.onMouseClick(parent, event, x, y);
    }

    public boolean onContextMenu(ModelNode node, MouseEvent event, int x, int y) {
        ModelNode parent;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("onContextMenu(): node=" + node + ",class=" + node.getClass().getName());
        }
        if (node instanceof HTMLAbstractUIElement) {
            Event jsEvent;
            HTMLAbstractUIElement uiElement = (HTMLAbstractUIElement)node;
            Function f = uiElement.getOncontextmenu();
            if (f != null && !Executor.executeFunction(uiElement, f, jsEvent = new Event("contextmenu", uiElement, event, x, y))) {
                return false;
            }
            HtmlRendererContext rcontext = uiElement.getHtmlRendererContext();
            if (rcontext != null && !rcontext.onContextMenu(uiElement, event)) {
                return false;
            }
        }
        if ((parent = node.getParentModelNode()) == null) {
            return true;
        }
        return this.onContextMenu(parent, event, x, y);
    }

    public void onMouseOver(ModelNode node, MouseEvent event, int x, int y, ModelNode limit) {
        while (node != null && node != limit) {
            if (node instanceof HTMLAbstractUIElement) {
                HtmlRendererContext rcontext;
                HTMLAbstractUIElement uiElement = (HTMLAbstractUIElement)node;
                uiElement.setMouseOver(true);
                Function f = uiElement.getOnmouseover();
                if (f != null) {
                    Event jsEvent = new Event("mouseover", uiElement, event, x, y);
                    Executor.executeFunction(uiElement, f, jsEvent);
                }
                if ((rcontext = uiElement.getHtmlRendererContext()) != null) {
                    rcontext.onMouseOver(uiElement, event);
                }
            }
            node = node.getParentModelNode();
        }
    }

    public void onMouseOut(ModelNode node, MouseEvent event, int x, int y, ModelNode limit) {
        while (node != null && node != limit) {
            if (node instanceof HTMLAbstractUIElement) {
                HtmlRendererContext rcontext;
                HTMLAbstractUIElement uiElement = (HTMLAbstractUIElement)node;
                uiElement.setMouseOver(false);
                Function f = uiElement.getOnmouseout();
                if (f != null) {
                    Event jsEvent = new Event("mouseout", uiElement, event, x, y);
                    Executor.executeFunction(uiElement, f, jsEvent);
                }
                if ((rcontext = uiElement.getHtmlRendererContext()) != null) {
                    rcontext.onMouseOut(uiElement, event);
                }
            }
            node = node.getParentModelNode();
        }
    }

    public boolean onDoubleClick(ModelNode node, MouseEvent event, int x, int y) {
        ModelNode parent;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("onDoubleClick(): node=" + node + ",class=" + node.getClass().getName());
        }
        if (node instanceof HTMLAbstractUIElement) {
            Event jsEvent;
            HTMLAbstractUIElement uiElement = (HTMLAbstractUIElement)node;
            Function f = uiElement.getOndblclick();
            if (f != null && !Executor.executeFunction(uiElement, f, jsEvent = new Event("dblclick", uiElement, event, x, y))) {
                return false;
            }
            HtmlRendererContext rcontext = uiElement.getHtmlRendererContext();
            if (rcontext != null && !rcontext.onDoubleClick(uiElement, event)) {
                return false;
            }
        }
        if ((parent = node.getParentModelNode()) == null) {
            return true;
        }
        return this.onDoubleClick(parent, event, x, y);
    }

    public boolean onMouseDisarmed(ModelNode node, MouseEvent event) {
        if (node instanceof HTMLLinkElementImpl) {
            ((HTMLLinkElementImpl)node).getCurrentStyle().setOverlayColor(null);
            return false;
        }
        ModelNode parent = node.getParentModelNode();
        if (parent == null) {
            return true;
        }
        return this.onMouseDisarmed(parent, event);
    }

    public boolean onMouseDown(ModelNode node, MouseEvent event, int x, int y) {
        HTMLAbstractUIElement uiElement;
        Function f;
        boolean pass = true;
        if (node instanceof HTMLAbstractUIElement && (f = (uiElement = (HTMLAbstractUIElement)node).getOnmousedown()) != null) {
            Event jsEvent = new Event("mousedown", uiElement, event, x, y);
            pass = Executor.executeFunction(uiElement, f, jsEvent);
        }
        if (node instanceof HTMLLinkElementImpl) {
            ((HTMLLinkElementImpl)node).getCurrentStyle().setOverlayColor("#9090FF80");
            return false;
        }
        if (!pass) {
            return false;
        }
        ModelNode parent = node.getParentModelNode();
        if (parent == null) {
            return true;
        }
        return this.onMouseDown(parent, event, x, y);
    }

    public boolean onMouseUp(ModelNode node, MouseEvent event, int x, int y) {
        HTMLAbstractUIElement uiElement;
        Function f;
        boolean pass = true;
        if (node instanceof HTMLAbstractUIElement && (f = (uiElement = (HTMLAbstractUIElement)node).getOnmouseup()) != null) {
            Event jsEvent = new Event("mouseup", uiElement, event, x, y);
            pass = Executor.executeFunction(uiElement, f, jsEvent);
        }
        if (node instanceof HTMLLinkElementImpl) {
            ((HTMLLinkElementImpl)node).getCurrentStyle().setOverlayColor(null);
            return false;
        }
        if (!pass) {
            return false;
        }
        ModelNode parent = node.getParentModelNode();
        if (parent == null) {
            return true;
        }
        return this.onMouseUp(parent, event, x, y);
    }

    public boolean onPressed(ModelNode node, InputEvent event, int x, int y) {
        Event jsEvent;
        HTMLAbstractUIElement uiElement;
        Function f;
        if (node instanceof HTMLAbstractUIElement && (f = (uiElement = (HTMLAbstractUIElement)node).getOnclick()) != null && !Executor.executeFunction(uiElement, f, jsEvent = new Event("click", uiElement, event, x, y))) {
            return false;
        }
        if (node instanceof HTMLInputElementImpl) {
            HTMLInputElementImpl hie = (HTMLInputElementImpl)node;
            if (hie.isSubmitInput()) {
                String name = hie.getName();
                FormInput[] formInputs = name == null ? null : new FormInput[]{new FormInput(name, hie.getValue())};
                hie.submitForm(formInputs);
            } else if (hie.isImageInput()) {
                String name = hie.getName();
                String prefix = name == null ? "" : name + ".";
                FormInput[] extraFormInputs = new FormInput[]{new FormInput(prefix + "x", String.valueOf(x)), new FormInput(prefix + "y", String.valueOf(y))};
                hie.submitForm(extraFormInputs);
            } else if (hie.isResetInput()) {
                hie.resetForm();
            }
        }
        return false;
    }

    public boolean onChange(ModelNode node) {
        Event jsEvent;
        HTMLSelectElementImpl uiElement;
        Function f;
        if (node instanceof HTMLSelectElementImpl && (f = (uiElement = (HTMLSelectElementImpl)node).getOnchange()) != null && !Executor.executeFunction(uiElement, f, jsEvent = new Event("change", uiElement))) {
            return false;
        }
        return false;
    }
}

