/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core2.network.proxy;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.netbeans.core.ProxySettings;
import org.netbeans.core2.network.proxy.ProxyLocationCache;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ProxyAutoConfig {
    private static final Map<String, ProxyAutoConfig> file2pac = new HashMap<String, ProxyAutoConfig>(2);
    private static final RequestProcessor RP = new RequestProcessor(ProxyAutoConfig.class);
    private static final String JS_HELPER_METHODS_BRIDGE_SCRIPT = "org/netbeans/core2/network/proxy/pacHelperMethods.js";
    private static final String PROTO_FILE = "file://";
    private static final String URL_CACHING_STRATEGY_KEY = "_URL_CACHE_STRATEGY_";
    private static final int PAC_DOWNLOAD_CONNECT_TIMEOUT_MS = 2000;
    private static final int PAC_DOWNLOAD_READ_TIMEOUT_MS = 2000;
    private static final Logger LOGGER = Logger.getLogger(ProxyAutoConfig.class.getName());
    private final ProxyLocationCache urlCache = new ProxyLocationCache();
    private Invocable inv = null;
    private URLCacheStrategyType canCacheURLs = URLCacheStrategyType.NEVER;
    private final RequestProcessor.Task initTask;
    private final URI pacURI;

    public static synchronized ProxyAutoConfig get(String pacFile) {
        if (file2pac.get(pacFile) == null) {
            LOGGER.fine("Init ProxyAutoConfig for " + pacFile);
            ProxyAutoConfig instance = null;
            try {
                instance = new ProxyAutoConfig(pacFile);
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(ProxyAutoConfig.class.getName()).warning("Parsing " + pacFile + " to URI throws " + ex);
            }
            finally {
                file2pac.put(pacFile, instance);
            }
        }
        return file2pac.get(pacFile);
    }

    private ProxyAutoConfig(String pacURL) throws URISyntaxException {
        assert (file2pac.get(pacURL) == null) : "Only once object for " + pacURL + " must exist.";
        String normPAC = this.normalizePAC(pacURL);
        this.pacURI = new URI(normPAC);
        this.initTask = RP.post(new Runnable(){

            @Override
            public void run() {
                ProxyAutoConfig.this.initEngine();
            }
        });
    }

    public URI getPacURI() {
        return this.pacURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEngine() {
        ScriptEngine eng;
        InputStream pacIS = null;
        try {
            pacIS = this.pacURI.isAbsolute() ? ProxyAutoConfig.downloadPAC(this.pacURI.toURL()) : null;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "PAC file could not be downloaded from " + this.pacURI + ". InputStream for " + this.pacURI + " throws " + ex);
        }
        if (pacIS == null) {
            return;
        }
        InputStream utils = ProxyAutoConfig.downloadUtils();
        try {
            eng = ProxyAutoConfig.evalPAC(pacIS, utils);
        }
        catch (ScriptException ex) {
            LOGGER.log(Level.WARNING, "Error while evaluating PAC file", ex);
            return;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Error while reading PAC file", ex);
            return;
        }
        finally {
            if (pacIS != null) {
                try {
                    pacIS.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINE, "While closing PAC input stream thrown " + ex, ex);
                }
            }
            if (utils != null) {
                try {
                    utils.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINE, "While closing PAC helper methods input stream thrown " + ex, ex);
                }
            }
        }
        assert (eng != null) : "JavaScript engine cannot be null";
        if (eng == null) {
            LOGGER.log(Level.WARNING, "JavaScript engine cannot be null");
            return;
        }
        URLCacheStrategyType urlCacheStrategy = (URLCacheStrategyType)((Object)eng.get(URL_CACHING_STRATEGY_KEY));
        if (urlCacheStrategy != null) {
            this.canCacheURLs = urlCacheStrategy;
        }
        this.inv = (Invocable)((Object)eng);
    }

    public synchronized List<Proxy> findProxyForURL(URI u) {
        List<Proxy> res;
        assert (this.initTask != null) : "initTask has be to posted.";
        if (!this.initTask.isFinished()) {
            while (!this.initTask.isFinished()) {
                try {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                        }
                    }).waitFinished(100L);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.FINEST, ex.getMessage(), ex);
                }
            }
        }
        if (this.inv == null) {
            return Collections.singletonList(Proxy.NO_PROXY);
        }
        Object proxies = null;
        if (this.canCacheURLs != URLCacheStrategyType.NEVER) {
            proxies = this.urlCache.getProxyStr(u);
        }
        if (proxies == null) {
            try {
                proxies = this.inv.invokeFunction("FindProxyForURL", u.toString(), u.getHost());
                if (proxies != null && this.canCacheURLs != URLCacheStrategyType.NEVER) {
                    this.urlCache.putProxyStr(u, proxies);
                }
            }
            catch (NoSuchMethodException | ScriptException ex) {
                LOGGER.log(Level.WARNING, "While invoking PAC file's FindProxyForURL(" + u + ", " + u.getHost() + " thrown " + ex, ex);
            }
        }
        if ((res = this.analyzeResult(u, proxies)) == null) {
            LOGGER.info("findProxyForURL(" + u + ") returns null.");
            res = Collections.emptyList();
        }
        LOGGER.fine("findProxyForURL(" + u + ") returns " + Arrays.asList(res));
        return res;
    }

    private static InputStream downloadPAC(URL pacURL) throws IOException {
        URLConnection conn = pacURL.openConnection(Proxy.NO_PROXY);
        conn.setConnectTimeout(2000);
        conn.setReadTimeout(2000);
        InputStream is = conn.getInputStream();
        return is;
    }

    private static ScriptEngine evalPAC(InputStream pacInput, InputStream utilsInput) throws ScriptException, IOException {
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName("JavaScript");
        LOGGER.log(Level.INFO, "PAC file evaluator using:  {0}", ProxyAutoConfig.getEngineInfo(engine));
        String pacScriptSource = ProxyAutoConfig.readInputStreamAsString(pacInput, 5120, "UTF-8");
        if (!ProxyAutoConfig.usesTimeDateFunctions(pacScriptSource)) {
            engine.put(URL_CACHING_STRATEGY_KEY, (Object)URLCacheStrategyType.LONG);
        }
        engine.eval(pacScriptSource);
        engine.eval(new InputStreamReader(utilsInput));
        return engine;
    }

    private static boolean usesTimeDateFunctions(String pacScriptSource) {
        Pattern pattern = Pattern.compile(".*(timeRange\\s*\\(|dateRange\\s*\\(|weekdayRange\\s*\\().*", 32);
        Matcher matcher = pattern.matcher(pacScriptSource);
        return matcher.matches();
    }

    private static String readInputStreamAsString(InputStream in, int initSize, String charsetName) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream buf = new ByteArrayOutputStream(initSize);
        int result = bis.read();
        while (result != -1) {
            byte b = (byte)result;
            buf.write(b);
            result = bis.read();
        }
        return buf.toString(charsetName);
    }

    private static String getEngineInfo(ScriptEngine engine) {
        StringBuilder sb = new StringBuilder();
        ScriptEngineFactory f = engine.getFactory();
        sb.append("LanguageName=");
        sb.append("\"").append(f.getLanguageName()).append("\"");
        sb.append(" ");
        sb.append("LanguageVersion=");
        sb.append("\"").append(f.getLanguageVersion()).append("\"");
        sb.append(" ");
        sb.append("EngineName=");
        sb.append("\"").append(f.getEngineName()).append("\"");
        sb.append(" ");
        sb.append("EngineVersion=");
        sb.append("\"").append(f.getEngineVersion()).append("\"");
        return sb.toString();
    }

    private List<Proxy> analyzeResult(URI uri, Object proxiesString) {
        if (proxiesString == null) {
            LOGGER.fine("Null result for " + uri);
            return null;
        }
        String protocol = uri.getScheme();
        assert (protocol != null) : "Invalid scheme of uri " + uri + ". Scheme cannot be null!";
        if (protocol == null) {
            return null;
        }
        Proxy.Type proxyType = "http".equals(protocol) || "https".equals(protocol) ? Proxy.Type.HTTP : Proxy.Type.SOCKS;
        StringTokenizer st = new StringTokenizer(proxiesString.toString(), ";");
        LinkedList<Proxy> proxies = new LinkedList<Proxy>();
        while (st.hasMoreTokens()) {
            String proxy = st.nextToken();
            if ("DIRECT".equals(proxy.trim())) {
                proxies.add(Proxy.NO_PROXY);
                continue;
            }
            String host = ProxyAutoConfig.getHost(proxy);
            Integer port = ProxyAutoConfig.getPort(proxy);
            if (host == null || port == null) continue;
            proxies.add(new Proxy(proxyType, new InetSocketAddress(host, (int)port)));
        }
        return proxies;
    }

    private static String getHost(String proxy) {
        int i;
        if (proxy.startsWith("PROXY ")) {
            proxy = proxy.substring(6);
        }
        if ((i = proxy.lastIndexOf(":")) <= 0 || i >= proxy.length() - 1) {
            LOGGER.info("No port in " + proxy);
            return null;
        }
        String host = proxy.substring(0, i);
        return ProxySettings.normalizeProxyHost((String)host);
    }

    private static Integer getPort(String proxy) {
        int i;
        if (proxy.startsWith("PROXY ")) {
            proxy = proxy.substring(6);
        }
        if ((i = proxy.lastIndexOf(":")) <= 0 || i >= proxy.length() - 1) {
            LOGGER.info("No port in " + proxy);
            return null;
        }
        String port = proxy.substring(i + 1);
        if (port.indexOf(47) >= 0) {
            port = port.substring(0, port.indexOf(47));
        }
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
            return null;
        }
    }

    private static InputStream downloadUtils() {
        InputStream is = ProxyAutoConfig.class.getClassLoader().getResourceAsStream(JS_HELPER_METHODS_BRIDGE_SCRIPT);
        if (is == null) {
            LOGGER.log(Level.SEVERE, "Resource org/netbeans/core2/network/proxy/pacHelperMethods.js not found in module's classpath");
        }
        return is;
    }

    private String normalizePAC(String pacURL) {
        File f;
        String fileLocation;
        int index = pacURL.indexOf("\n");
        if (index != -1) {
            pacURL = pacURL.substring(0, index);
        }
        if ((index = pacURL.indexOf("\r")) != -1) {
            pacURL = pacURL.substring(0, index);
        }
        if ((fileLocation = pacURL).startsWith(PROTO_FILE)) {
            fileLocation = fileLocation.substring(PROTO_FILE.length());
        }
        if ((index = (pacURL = (f = new File(fileLocation)).canRead() ? Utilities.toURI((File)f).toString() : pacURL.replaceAll("\\\\", "/")).indexOf(" ")) != -1) {
            pacURL = pacURL.substring(0, index);
        }
        return pacURL.trim();
    }

    public boolean usesCaching() {
        return this.canCacheURLs != URLCacheStrategyType.NEVER;
    }

    private static enum URLCacheStrategyType {
        NEVER,
        LONG;

    }
}

