/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.tx3.java.api.constraints.discovery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.maltego.tx3.java.api.constraints.LogicalOperation;
import com.maltego.tx3.java.api.constraints.discovery.DiscoveryInputConstraint;
import java.util.List;
import java.util.stream.Stream;

public class CompositeDiscoveryConstraint<T>
extends DiscoveryInputConstraint<T> {
    private final List<DiscoveryInputConstraint<T>> constraints;
    private final LogicalOperation operation;

    @JsonCreator
    public CompositeDiscoveryConstraint(@JsonProperty(value="constraints") List<DiscoveryInputConstraint<T>> constraints, @JsonProperty(value="operation") String operation) {
        this.constraints = constraints;
        this.operation = LogicalOperation.valueOf(operation.toUpperCase());
    }

    @Override
    public boolean evaluate(T inputValue) {
        Stream<Boolean> evaluations = this.constraints.stream().map(c -> c.evaluate(inputValue));
        switch (this.operation) {
            case ANY: {
                return evaluations.anyMatch(Boolean::booleanValue);
            }
            case ALL: {
                return evaluations.allMatch(Boolean::booleanValue);
            }
            case NONE: {
                return evaluations.noneMatch(Boolean::booleanValue);
            }
        }
        throw new IllegalArgumentException("Invalid operation: " + (Object)((Object)this.operation));
    }

    public List<DiscoveryInputConstraint<T>> getConstraints() {
        return this.constraints;
    }

    public LogicalOperation getOperation() {
        return this.operation;
    }
}

