/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.collect;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStore;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutStore;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.structure.GraphStructureStore;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.views.collect.CollectionNodeLayoutStore;
import com.paterva.maltego.graph.store.views.collect.CollectionNodeStructureStore;
import com.paterva.maltego.graph.store.views.impl.CollectionNodesSerializer;
import com.paterva.maltego.graph.store.views.impl.InMemoryCollectionNodes;
import com.paterva.maltego.graph.store.views.impl.structures.ViewEntity;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class CollectionNodeView
extends GraphStoreView {
    private static final Logger LOG = Logger.getLogger(CollectionNodeView.class.getName());
    private final GraphID _graphID;
    private final CollectionNodeStructureStore _structureStore;
    private final CollectionNodeLayoutStore _layoutStore;
    private final GraphModelViewMappings _mappings;
    private final InMemoryCollectionNodes _collectionNodes;

    public CollectionNodeView(GraphID graphID) throws GraphStoreException {
        super(graphID);
        this._graphID = graphID;
        this._collectionNodes = new InMemoryCollectionNodes(this._graphID);
        this._structureStore = new CollectionNodeStructureStore(this._graphID, this._collectionNodes);
        this._layoutStore = new CollectionNodeLayoutStore(this._graphID, this._collectionNodes);
        this._mappings = this._collectionNodes;
    }

    public boolean isInMemory() {
        return false;
    }

    public void syncWithModel() {
        if (!CollectionNodesSerializer.getInstance(this._graphID).isSynced()) {
            this._structureStore.syncWithModel(null);
            this._layoutStore.syncWithModel();
        } else {
            GraphStructureMods loadedViewMods = this._collectionNodes.loadFromSerializer();
            if (!this.doSanityCheck()) {
                LOG.warning("The graph file fell out of sync with its collection settings. Using default values.");
                loadedViewMods = null;
            }
            CollectionNodesSerializer.getInstance(this._graphID).reset();
            this._structureStore.syncWithModel(loadedViewMods);
            this._layoutStore.syncWithModel();
            CollectionNodesSerializer.getInstance(this._graphID).setSynced(false);
        }
    }

    private boolean doSanityCheck() {
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            Set structureEntities = structureReader.getEntities();
            HashSet<EntityID> collectionNodeEntities = new HashSet<EntityID>();
            for (Map.Entry<EntityID, ViewEntity> entry : this._collectionNodes.getViewEntities().entrySet()) {
                EntityID entityID = entry.getKey();
                ViewEntity viewEntity = entry.getValue();
                if (viewEntity.isCollection()) {
                    collectionNodeEntities.addAll(viewEntity.getCollection());
                    continue;
                }
                collectionNodeEntities.add(entityID);
            }
            return structureEntities.equals(collectionNodeEntities);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return true;
        }
    }

    public GraphStructureStore getGraphStructureStore() {
        return this._structureStore;
    }

    public GraphLayoutStore getGraphLayoutStore() {
        return this._layoutStore;
    }

    public GraphModelViewMappings getModelViewMappings() {
        return this._mappings;
    }

    public GraphDataStore getGraphDataStore() {
        return this.getModel().getGraphDataStore();
    }

    public void writeCache(OutputStream os) throws GraphStoreException {
        try {
            CollectionNodesSerializer.getInstance(this._graphID).write(this._collectionNodes, os);
        }
        catch (IOException ex) {
            throw new GraphStoreException((Throwable)ex);
        }
    }
}

