/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.data.GraphDataMods;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.views.impl.CollectStrategy;
import com.paterva.maltego.graph.store.views.impl.ModelSnapshotData;
import com.paterva.maltego.graph.store.views.impl.structures.EntityLinks;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class RuleLogger
implements CollectStrategy {
    private static final Logger LOG = Logger.getLogger(RuleLogger.class.getName());
    private final CollectStrategy _collectionStrategy;

    RuleLogger(CollectStrategy collectionStrategy) {
        this._collectionStrategy = collectionStrategy;
    }

    private void log(String prefix, ModelSnapshotData msd, Map<EntityID, EntityLinks> entities, Map<LinkID, LinkEntityIDs> links) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("--------").append(prefix).append("--------\n");
        sb.append("   class = ").append(this._collectionStrategy.getClass().getName()).append("\n");
        sb.append("Entities\n").append(entities.toString()).append("\n");
        sb.append("Links\n").append(links.toString()).append("\n");
        sb.append("CollectedViewEntities\n").append(msd.getCollectedViewEntities().toString()).append("\n");
        sb.append("CollectedViewLinks\n").append(msd.getCollectedViewLinks().toString()).append("\n");
        sb.append("\n");
        LOG.log(Level.FINE, sb.toString());
    }

    @Override
    public void collect(ModelSnapshotData msd, Map<EntityID, EntityLinks> entities, Map<LinkID, LinkEntityIDs> links) throws GraphStoreException {
        this.log("Before", msd, entities, links);
        this._collectionStrategy.collect(msd, entities, links);
        this.log("After", msd, entities, links);
    }

    @Override
    public Set<EntityID> determineTouchedViewEntities(GraphStructureMods imsm, GraphDataMods imdm) throws GraphStoreException {
        Set<EntityID> touched = this._collectionStrategy.determineTouchedViewEntities(imsm, imdm);
        return touched;
    }
}

