/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl.rules.chain;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.data.GraphDataMods;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.views.collect.CollectionSettings;
import com.paterva.maltego.graph.store.views.impl.CollectStrategy;
import com.paterva.maltego.graph.store.views.impl.InMemoryCollectionNodes;
import com.paterva.maltego.graph.store.views.impl.ModelSnapshotData;
import com.paterva.maltego.graph.store.views.impl.rules.chain.Chain;
import com.paterva.maltego.graph.store.views.impl.rules.chain.ChainEndPoints;
import com.paterva.maltego.graph.store.views.impl.rules.chain.ChainSet;
import com.paterva.maltego.graph.store.views.impl.structures.EntityLinks;
import com.paterva.maltego.graph.store.views.impl.structures.LinkDirection;
import com.paterva.maltego.graph.store.views.impl.structures.NeighbourMode;
import com.paterva.maltego.graph.store.views.impl.structures.Pair;
import com.paterva.maltego.graph.store.views.impl.structures.ViewEntity;
import com.paterva.maltego.graph.store.views.impl.structures.ViewLink;
import com.paterva.maltego.graph.store.views.impl.tools.CollectionUtils;
import com.paterva.maltego.graph.store.views.impl.tools.UncollectUtils;
import com.paterva.maltego.util.BulkStatusDisplayer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ChainingCollectionRule
implements CollectStrategy {
    private static final int MIN_REQUIRED = 3;
    private static final int MAX_NEIGHBOURS = 2;
    private static final Logger LOG = Logger.getLogger(ChainingCollectionRule.class.getName());
    private final InMemoryCollectionNodes _collectionNodes;
    private Map<EntityID, EntityLinks> _entities;
    private Map<LinkID, LinkEntityIDs> _links;
    private ModelSnapshotData _msd;
    private GraphStructureMods _imsm;
    private GraphDataMods _imdm;
    private final UncollectUtils _uncollectUtils;
    private final Set<EntityID> _touchedViewEntities = new HashSet<EntityID>();
    private int _minRequired;
    private static final boolean SKIP_THIS_COLLECTION = false;

    public ChainingCollectionRule(InMemoryCollectionNodes collectionNodes) {
        this._collectionNodes = collectionNodes;
        this._uncollectUtils = new UncollectUtils(collectionNodes);
    }

    @Override
    public void collect(ModelSnapshotData msd, Map<EntityID, EntityLinks> entities, Map<LinkID, LinkEntityIDs> links) throws GraphStoreException {
        this._minRequired = (int)(3.0 * CollectionSettings.getDefault().getRuleRatio());
        this._entities = entities;
        this._links = links;
        this._msd = msd;
        Iterator<EntityID> entItr = this._entities.keySet().iterator();
        HashSet<Chain> allChains = new HashSet<Chain>();
        HashSet<EntityID> allVisitedEntities = new HashSet<EntityID>();
        HashSet<EntityID> entitiesInChains = new HashSet<EntityID>();
        BulkStatusDisplayer status = new BulkStatusDisplayer("Grouping chains (%d/" + this._entities.size() + ")");
        while (entItr.hasNext()) {
            status.increment();
            EntityID entity = entItr.next();
            if (allVisitedEntities.contains(entity)) continue;
            Set<EntityID> parentEntities = CollectionUtils.getEntities(this._msd, this._entities, this._links, entity, NeighbourMode.PARENTS, 2);
            Set<EntityID> childrenEntities = CollectionUtils.getEntities(this._msd, this._entities, this._links, entity, NeighbourMode.CHILDREN, 2);
            if (parentEntities.size() >= this._minRequired) {
                for (EntityID sourceID : parentEntities) {
                    this.addChain(allChains, allVisitedEntities, entitiesInChains, entity, sourceID);
                }
            }
            if (childrenEntities.size() >= this._minRequired) {
                for (EntityID targetID : childrenEntities) {
                    this.addChain(allChains, allVisitedEntities, entitiesInChains, entity, targetID);
                }
            }
            allVisitedEntities.add(entity);
        }
        status.clear();
        this.collectChains(allChains);
    }

    private void collectChains(Set<Chain> allChains) throws GraphStoreException {
        if (allChains.isEmpty()) {
            return;
        }
        Map<ChainEndPoints, Set<Chain>> groupedChains = this.groupChains(allChains);
        HashMap<ChainEndPoints, Set<ChainSet>> groupedCollectableChains = new HashMap<ChainEndPoints, Set<ChainSet>>();
        for (Map.Entry<ChainEndPoints, Set<Chain>> entry : groupedChains.entrySet()) {
            ChainEndPoints endPoints = entry.getKey();
            Set<Chain> collectionChainSet = entry.getValue();
            Set<ChainSet> collectableChains = this.createCollectableChains(collectionChainSet);
            Iterator<ChainSet> iterator = collectableChains.iterator();
            while (iterator.hasNext()) {
                ChainSet next = iterator.next();
                if (next.isCollectable(this._msd)) continue;
                iterator.remove();
            }
            if (collectableChains.isEmpty()) continue;
            groupedCollectableChains.put(endPoints, collectableChains);
        }
        this.makeCollections(groupedCollectableChains);
    }

    private void makeCollections(Map<ChainEndPoints, Set<ChainSet>> chains) throws GraphStoreException {
        for (Map.Entry<ChainEndPoints, Set<ChainSet>> entry : chains.entrySet()) {
            EntityLinks mods;
            ChainEndPoints endPoints = entry.getKey();
            Set<ChainSet> innerChains = entry.getValue();
            Pair<EntityLinks, EntityLinks> endPointLinkMods = new Pair<EntityLinks, EntityLinks>(new EntityLinks(), new EntityLinks());
            for (ChainSet chainSet : innerChains) {
                chainSet.collect(endPoints, this._msd, this._collectionNodes, this._entities, this._links, endPointLinkMods);
            }
            if (endPoints.getEndPt1() != null) {
                EntityLinks endPt1Links = this._entities.get(endPoints.getEndPt1());
                mods = endPointLinkMods.getOne();
                this.applyLinkMods(endPt1Links, mods);
            }
            if (endPoints.getEndPt2() == null) continue;
            EntityLinks endPt2Links = this._entities.get(endPoints.getEndPt2());
            mods = endPointLinkMods.getTwo();
            this.applyLinkMods(endPt2Links, mods);
        }
    }

    private void applyLinkMods(EntityLinks endPtLinks, EntityLinks mods) {
        Set<LinkID> viewIncoming = endPtLinks.getViewIncomingLinks();
        viewIncoming.removeAll(mods.getModelIncomingLinks());
        viewIncoming.addAll(mods.getViewIncomingLinks());
        Set<LinkID> viewOutgoing = endPtLinks.getViewOutgoingLinks();
        viewOutgoing.removeAll(mods.getModelOutgoingLinks());
        viewOutgoing.addAll(mods.getViewOutgoingLinks());
    }

    private Set<ChainSet> createCollectableChains(Set<Chain> collectionChainSet) {
        HashSet<ChainSet> collection = new HashSet<ChainSet>();
        for (Chain chain : collectionChainSet) {
            this.addOrCreate(collection, chain);
        }
        return collection;
    }

    private void addOrCreate(Set<ChainSet> collections, Chain chain) {
        for (Set set : collections) {
            if (!((Chain)set.iterator().next()).matches(chain)) continue;
            set.add(chain);
            return;
        }
        ChainSet s = new ChainSet();
        s.add(chain);
        collections.add(s);
    }

    private Map<ChainEndPoints, Set<Chain>> groupChains(Set<Chain> chains) {
        HashMap<ChainEndPoints, Set<Chain>> collectableChains = new HashMap<ChainEndPoints, Set<Chain>>();
        for (Chain chain : chains) {
            this.addOrCreate(collectableChains, chain);
        }
        return collectableChains;
    }

    private void addOrCreate(Map<ChainEndPoints, Set<Chain>> collectableChains, Chain chain) {
        ChainEndPoints cep = new ChainEndPoints(chain.getEndPt1(), chain.getEndPt2());
        Set<Chain> collection = collectableChains.get(cep);
        if (collection == null) {
            collection = new HashSet<Chain>();
            collectableChains.put(cep, collection);
        }
        collection.add(chain);
    }

    private void addChain(Set<Chain> allChains, Set<EntityID> allVisitedEntities, Set<EntityID> entitiesInChains, EntityID startEndPoint, EntityID nextPossibleChainEntity) throws GraphStoreException {
        Chain chain = new Chain(this._entities, this._links);
        HashSet<EntityID> visitedChainEntities = new HashSet<EntityID>();
        visitedChainEntities.add(startEndPoint);
        chain.addEndPoint(startEndPoint);
        chain = this.buildChain(chain, nextPossibleChainEntity, visitedChainEntities, entitiesInChains);
        if (chain.hasChainEntities() && chain.isCollectable(this._msd, 2)) {
            allChains.add(chain);
            entitiesInChains.addAll(chain.getChainEntitiesWithOutEndPoints());
            allVisitedEntities.addAll(chain.getChainEntitiesWithOutEndPoints());
        }
    }

    private boolean isNeighbourChainable(Set<EntityID> neighbour) {
        int neighbourCount = neighbour.size();
        return neighbourCount <= this._minRequired - 1;
    }

    private Chain buildChain(Chain chain, EntityID ent, Set<EntityID> visitedEntities, Set<EntityID> entitiesInChains) throws GraphStoreException {
        if (entitiesInChains.contains(ent) || visitedEntities.contains(ent) || chain.getEndPt1().equals((Object)ent)) {
            chain.removeAllChainEntities();
            return chain;
        }
        visitedEntities.add(ent);
        Set<EntityID> incomingNeighbours = CollectionUtils.getEntities(this._msd, this._entities, this._links, ent, NeighbourMode.PARENTS);
        Set<EntityID> outgoingNeighbours = CollectionUtils.getEntities(this._msd, this._entities, this._links, ent, NeighbourMode.CHILDREN);
        int incomingNeighboursSize = incomingNeighbours.size();
        int outgoingNeighboursSize = outgoingNeighbours.size();
        HashSet<EntityID> neighbour = new HashSet<EntityID>(incomingNeighbours.size() + outgoingNeighbours.size());
        neighbour.addAll(incomingNeighbours);
        neighbour.addAll(outgoingNeighbours);
        if (this.isNeighbourChainable(neighbour)) {
            EntityID otherEnt = this.getOtherEntity(chain, neighbour, ent);
            if (otherEnt != null) {
                chain.addChainEntity(ent, incomingNeighboursSize, outgoingNeighboursSize, this._msd.getEntityType(ent));
                this.buildChain(chain, otherEnt, visitedEntities, entitiesInChains);
            } else if (neighbour.size() == 1) {
                chain.addEndPoint(null);
                chain.addChainEntity(ent, incomingNeighboursSize, outgoingNeighboursSize + 1, this._msd.getEntityType(ent));
            } else {
                chain.removeAllChainEntities();
            }
        } else {
            chain.addEndPoint(ent);
        }
        return chain;
    }

    private EntityID getOtherEntity(Chain chain, Set<EntityID> neighbour, EntityID ent) {
        EntityID otherEnt = null;
        EntityID endPt1 = chain.getEndPt1();
        List<EntityID> chainEntitiesWithOutEndPoints = chain.getChainEntitiesWithOutEndPoints();
        for (EntityID entityID : neighbour) {
            if (entityID.equals((Object)ent) || entityID.equals((Object)endPt1) || chainEntitiesWithOutEndPoints.contains(entityID)) continue;
            otherEnt = entityID;
            break;
        }
        return otherEnt;
    }

    private EntityID findEndPoint(Pair<EntityID, ViewEntity> viewEntityPair, LinkDirection direction) throws GraphStoreException {
        EntityID possibleEndPoint = viewEntityPair.getOne();
        EntityLinks allLinks = viewEntityPair.getTwo().getAllLinks();
        int otherLinkCount = direction == LinkDirection.INCOMING ? allLinks.getModelIncomingCount() : allLinks.getModelOutgoingCount();
        Map<LinkID, ViewLink> viewLinks = this._collectionNodes.getViewLinks();
        EntityID endPoint = null;
        if (otherLinkCount >= this._minRequired) {
            endPoint = possibleEndPoint;
            Set<LinkID> finalLinks = direction == LinkDirection.INCOMING ? allLinks.getViewIncomingLinks() : allLinks.getViewOutgoingLinks();
            for (LinkID finalLink : finalLinks) {
                LinkEntityIDs entities = viewLinks.get(finalLink).getEntities();
                endPoint = direction == LinkDirection.INCOMING ? entities.getSourceID() : entities.getTargetID();
            }
        } else {
            Set<LinkID> viewEntityViewLinks = direction == LinkDirection.INCOMING ? allLinks.getViewIncomingLinks() : allLinks.getViewOutgoingLinks();
            for (LinkID viewEntityViewLink : viewEntityViewLinks) {
                ViewLink vl = viewLinks.get(viewEntityViewLink);
                LinkEntityIDs entities = vl.getEntities();
                EntityID ent = direction == LinkDirection.INCOMING ? entities.getSourceID() : entities.getTargetID();
                endPoint = this.findEndPoint(this._collectionNodes.getViewEntityPair(ent), direction);
                if (endPoint == null) continue;
                break;
            }
        }
        return endPoint;
    }

    private Set<EntityID> markAllChildren(EntityID currentEnt, EntityID startEndPt, EntityID finalEndPt, LinkDirection direction) {
        int otherLinkCount;
        HashSet<EntityID> touched = new HashSet<EntityID>();
        touched.add(currentEnt);
        Map<EntityID, ViewEntity> viewEntities = this._collectionNodes.getViewEntities();
        EntityLinks allLinks = viewEntities.get(currentEnt).getAllLinks();
        int n = otherLinkCount = direction == LinkDirection.INCOMING ? allLinks.getModelIncomingCount() : allLinks.getModelOutgoingCount();
        if ((currentEnt.equals((Object)startEndPt) || otherLinkCount < this._minRequired) && !currentEnt.equals((Object)finalEndPt)) {
            Map<LinkID, ViewLink> viewLinks = this._collectionNodes.getViewLinks();
            Set<LinkID> viewEntityViewLinks = direction == LinkDirection.INCOMING ? allLinks.getViewIncomingLinks() : allLinks.getViewOutgoingLinks();
            for (LinkID viewEntityViewLink : viewEntityViewLinks) {
                ViewLink vl = viewLinks.get(viewEntityViewLink);
                LinkEntityIDs entities = vl.getEntities();
                EntityID ent = direction == LinkDirection.INCOMING ? entities.getSourceID() : entities.getTargetID();
                touched.addAll(this.markAllChildren(ent, startEndPt, finalEndPt, direction));
            }
        }
        return touched;
    }

    private Set<EntityID> lookupTouchedFormExistingModelEntitiesInView(Set<EntityID> existingModelEntitiesInView) throws GraphStoreException {
        HashSet<EntityID> touched = new HashSet<EntityID>();
        for (EntityID existingModelEntity : existingModelEntitiesInView) {
            Pair<EntityID, ViewEntity> viewEntityPair = this._collectionNodes.getViewEntityPair(existingModelEntity);
            EntityID viewEndPt1 = this.findEndPoint(viewEntityPair, LinkDirection.INCOMING);
            EntityID viewEndPt2 = this.findEndPoint(viewEntityPair, LinkDirection.OUTGOING);
            if (viewEndPt1 != null && !touched.contains(viewEndPt1)) {
                touched.addAll(this.markAllChildren(viewEndPt1, viewEndPt1, viewEndPt2, LinkDirection.OUTGOING));
            }
            if (viewEndPt2 == null || touched.contains(viewEndPt2)) continue;
            touched.addAll(this.markAllChildren(viewEndPt2, viewEndPt2, viewEndPt1, LinkDirection.INCOMING));
        }
        return touched;
    }

    @Override
    public Set<EntityID> determineTouchedViewEntities(GraphStructureMods imsm, GraphDataMods imdm) throws GraphStoreException {
        this._touchedViewEntities.clear();
        this._imsm = imsm;
        this._imdm = imdm;
        Set<EntityID> existingModelEntitiesInView = this._uncollectUtils.getExistingModelEntitiesInView(this._imsm, this._imdm);
        Set<EntityID> touchedFormExistingModelEntitiesInView = this.lookupTouchedFormExistingModelEntitiesInView(existingModelEntitiesInView);
        this._touchedViewEntities.addAll(this._uncollectUtils.addNeighbouringCollections(touchedFormExistingModelEntitiesInView, new HashSet<EntityID>(touchedFormExistingModelEntitiesInView)));
        return this._touchedViewEntities;
    }
}

