/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.crypto;

import com.maltego.cloud.crypto.util.CryptoUtilities;
import com.paterva.maltego.util.FileUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.util.Base64;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.crypto.SecretKey;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public interface MasterKeyStore {
    public static MasterKeyStore getDefault() {
        return (MasterKeyStore)Lookup.getDefault().lookup(MasterKeyStore.class);
    }

    public void reset();

    public void storeMasterKey(SecretKey var1) throws GeneralSecurityException, IOException;

    public SecretKey readMasterKeyFromStore() throws GeneralSecurityException, IOException;

    public static final class DefaultMasterKeyStore
    implements MasterKeyStore {
        private static final Logger LOG = Logger.getLogger(DefaultMasterKeyStore.class.getName());
        private static final String KEYSTORE_FILE = "GraphKeystore.pkcs12";
        private static final String KEYSTORE_TYPE = "pkcs12";
        private static final String ALIAS_MASTER_KEY = "master-key";
        private static final String PREF_KEYSTORE_PASS = "MasterKeyStore.KeystorePass";
        private final Preferences prefs = NbPreferences.forModule(DefaultMasterKeyStore.class);

        @Override
        public void reset() {
            this.prefs.remove(PREF_KEYSTORE_PASS);
            File file = this.getKeystoreFile();
            if (file != null && file.exists()) {
                file.delete();
            }
        }

        @Override
        public void storeMasterKey(SecretKey masterKey) throws GeneralSecurityException, IOException {
            File keystoreFile = this.getKeystoreFile();
            String pkcsPassword = this.prefs.get(PREF_KEYSTORE_PASS, null);
            if (pkcsPassword == null) {
                if (keystoreFile.exists()) {
                    LOG.warning("Keystore file exists but password is missing. Re-creating the keystore");
                }
                pkcsPassword = this.generateKeystorePass();
                this.prefs.put(PREF_KEYSTORE_PASS, pkcsPassword);
            }
            KeyStore keystore = KeyStore.getInstance(KEYSTORE_TYPE);
            char[] pass = pkcsPassword.toCharArray();
            if (!keystoreFile.exists()) {
                LOG.info("Creating keystore");
                keystore.load(null, pass);
            } else {
                LOG.info("Loading keystore");
                keystore.load(new FileInputStream(keystoreFile), pass);
            }
            KeyStore.SecretKeyEntry secretKey = new KeyStore.SecretKeyEntry(masterKey);
            KeyStore.PasswordProtection passwordParam = new KeyStore.PasswordProtection(pass);
            keystore.setEntry(ALIAS_MASTER_KEY, secretKey, passwordParam);
            LOG.info("Storing master key in keystore");
            keystore.store(new FileOutputStream(keystoreFile), pass);
        }

        @Override
        public SecretKey readMasterKeyFromStore() throws GeneralSecurityException, IOException {
            File keystoreFile = this.getKeystoreFile();
            String pkcsPassword = this.prefs.get(PREF_KEYSTORE_PASS, null);
            if (pkcsPassword == null) {
                if (keystoreFile.exists()) {
                    LOG.warning("Keystore file exists but password is missing. Removing keystore file");
                    this.reset();
                }
                return null;
            }
            if (!keystoreFile.exists()) {
                return null;
            }
            KeyStore keystore = KeyStore.getInstance(KEYSTORE_TYPE);
            char[] pass = pkcsPassword.toCharArray();
            LOG.info("Loading keystore");
            keystore.load(new FileInputStream(keystoreFile), pass);
            LOG.info("Reading master key from keystore");
            Key key = keystore.getKey(ALIAS_MASTER_KEY, pass);
            return (SecretKey)key;
        }

        private String generateKeystorePass() {
            byte[] passBytes = CryptoUtilities.generateBytes(32);
            String encodeToString = Base64.getEncoder().encodeToString(passBytes);
            return encodeToString;
        }

        private File getKeystoreFile() {
            boolean machineLicense = false;
            File userDir = FileUtilities.getUserDir((boolean)machineLicense);
            File lf = null;
            if (userDir == null) {
                LOG.severe("Unable to determine license directory location");
            } else {
                lf = new File(userDir, KEYSTORE_FILE);
            }
            return lf;
        }
    }
}

