/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config;

import com.paterva.maltego.java.config.app.AppUtils;
import com.paterva.maltego.java.config.jre.JavaInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JavaRuntimeSelector {
    private static final String[] PREFERRED_JAVAS = new String[]{"1.8.", "8.", "1.11.", "11.", "1.17.", "17."};

    public String select(Map<String, JavaInfo> javaRuntimes) {
        System.out.println("runtimes: " + javaRuntimes.size());
        Map<String, JavaInfo> preferedJavaRuntimes = this.getPreferedJavaRuntimes(javaRuntimes);
        Map.Entry<String, JavaInfo> selected = this.selectBetterJava(preferedJavaRuntimes);
        if (selected == null) {
            selected = this.selectBetterJava(javaRuntimes);
        }
        return selected != null ? selected.getKey() : null;
    }

    private Map.Entry<String, JavaInfo> selectBetterJava(Map<String, JavaInfo> javaRuntimes) {
        Map.Entry<String, JavaInfo> selected = null;
        Iterator<Map.Entry<String, JavaInfo>> iterator = javaRuntimes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, JavaInfo> entry;
            JavaInfo oldInfo;
            String oldPath = selected != null ? (String)selected.getKey() : null;
            if (!this.isNewBetter(oldPath, oldInfo = selected != null ? (JavaInfo)selected.getValue() : null, (entry = iterator.next()).getKey(), entry.getValue())) continue;
            selected = entry;
        }
        return selected;
    }

    private Map<String, JavaInfo> getPreferedJavaRuntimes(Map<String, JavaInfo> javaRuntimes) {
        HashMap<String, JavaInfo> preferedJavaRuntimes = new HashMap<String, JavaInfo>();
        for (Map.Entry<String, JavaInfo> entry : javaRuntimes.entrySet()) {
            String[] types;
            String path = entry.getKey();
            String pathLowerCase = path.toLowerCase();
            for (String type : types = new String[]{"jdk", "jre", "java"}) {
                for (String preferredJava : PREFERRED_JAVAS) {
                    if (!pathLowerCase.contains(type + preferredJava) && !pathLowerCase.contains(type + "-" + preferredJava)) continue;
                    preferedJavaRuntimes.put(path, entry.getValue());
                }
            }
        }
        return preferedJavaRuntimes;
    }

    private boolean isNewBetter(String oldPath, JavaInfo oldInfo, String newPath, JavaInfo newInfo) {
        if (oldInfo == null || oldPath == null) {
            return true;
        }
        if (this.is64(oldInfo) && !this.is64(newInfo)) {
            return false;
        }
        if (newInfo.getVersion().newerThan(oldInfo.getVersion())) {
            return true;
        }
        if (oldInfo.getVersion().newerThan(newInfo.getVersion())) {
            return false;
        }
        if (AppUtils.countDigits(newPath) > AppUtils.countDigits(oldPath)) {
            return false;
        }
        return oldPath.length() >= newPath.length();
    }

    private boolean is64(JavaInfo info) {
        return info.getArch().contains("64");
    }
}

