/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.state;

import com.paterva.maltego.chatapi.conn.ConnectionStatus;
import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.Participant;
import com.paterva.maltego.collab.ParticipantPresence;
import com.paterva.maltego.collab.Payload;
import com.paterva.maltego.collab.PayloadCollection;
import com.paterva.maltego.collab.graph.GraphSnapshot;
import com.paterva.maltego.collab.graph.state.AbstractConnectionState;
import com.paterva.maltego.collab.graph.state.RequestGraphMessage;
import com.paterva.maltego.collab.graph.state.SignalMessage;
import com.paterva.maltego.util.NormalException;

public class StateConnected
extends AbstractConnectionState {
    public StateConnected() {
        super(ConnectionStatus.Connected, true);
    }

    @Override
    protected void run() {
        PayloadCollection livePayloads = this.liveQueue().payloads();
        if (!livePayloads.isEmpty()) {
            try {
                this.rx().payloadsReceived(livePayloads);
                this.liveQueue().clear();
            }
            catch (CollaborationException ex) {
                this.handleError("Error handling live payload", (Exception)((Object)ex));
            }
        }
        this.debug("connected");
        this.progress(LogMessageLevel.Info, "Connection established", 100);
    }

    @Override
    public void sendPayload(String to, String xml) throws CollaborationException {
        this.tx().sendPayload(to, xml);
    }

    @Override
    public void payloadsReceived(PayloadCollection payloads) {
        Payload signalPayload = payloads.first("signal", false);
        if (signalPayload != null) {
            try {
                SignalMessage signal = SignalMessage.parse(signalPayload.getBody());
                this.signalReceived(signalPayload.getFrom(), signal);
            }
            catch (CollaborationException ex) {
                this.handleError("Cannot parse signal message", (Exception)((Object)ex));
            }
        } else {
            try {
                this.rx().payloadsReceived(payloads);
            }
            catch (CollaborationException ex) {
                this.handleError("Error handling payload", (Exception)((Object)ex));
            }
        }
    }

    private void signalReceived(Participant from, SignalMessage signal) {
        if ("getgraph".equals(signal.getAction()) && signal.getType() == SignalMessage.Type.Request) {
            this.debug("Received graph request from " + from.getName());
            if (this.graphProvider().hasGraph()) {
                try {
                    this.debug("sending graph");
                    this.sendGraph(from.getID());
                }
                catch (CollaborationException ex) {
                    NormalException.showStackTrace((Throwable)((Object)ex));
                }
            } else {
                this.debug("Don't have a graph to send");
                this.sendBusyResponse(from);
            }
        }
    }

    private void sendBusyResponse(Participant to) {
        try {
            this.tx().sendPayload(to.getID(), SignalMessage.createErrorResponse("getgraph", 503, "busy").toXml());
        }
        catch (CollaborationException ex) {
            this.handleError("Failed to send busy response", (Exception)((Object)ex));
        }
    }

    @Override
    public void updateStatus(ParticipantPresence presence, String message) throws CollaborationException {
        this.tx().updateStatus(presence, message);
    }

    private void sendGraph(String to) throws CollaborationException {
        GraphSnapshot snapshot = this.graphProvider().createSnapshot();
        if (snapshot != null) {
            this.tx().sendPayload(to, RequestGraphMessage.response(snapshot.getLastTransactionID(), snapshot.getTransactions(), snapshot.getEntitySpecs(), snapshot.getLinkSpecs(), snapshot.getIcons(), snapshot.getLayoutSettings(), snapshot.getCollectionSettings()).toXml());
        }
    }
}

