/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session;

import com.paterva.maltego.chatapi.conn.ConnectionInitiationCallback;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.session.CollaborationSession;
import com.paterva.maltego.collab.session.CollaborationSessionInfo;
import org.openide.util.Lookup;

public abstract class CollaborationSessionManager {
    public static CollaborationSessionManager getDefault() {
        CollaborationSessionManager factory = (CollaborationSessionManager)Lookup.getDefault().lookup(CollaborationSessionManager.class);
        if (factory == null) {
            factory = new DummySessionManager();
        }
        return factory;
    }

    public abstract CollaborationSession createSession(CollaborationSessionInfo var1, ConnectionInitiationCallback var2) throws CollaborationException;

    public abstract void openSession(CollaborationSession var1, ConnectionInitiationCallback var2) throws CollaborationException;

    public abstract void configureSession(CollaborationSession var1, ConnectionInitiationCallback var2) throws CollaborationException;

    public abstract void sendSessionID(CollaborationSession var1, String var2, ConnectionInitiationCallback var3) throws CollaborationException;

    public abstract void closeSession(CollaborationSession var1) throws CollaborationException;

    private static class DummySessionManager
    extends CollaborationSessionManager {
        private DummySessionManager() {
        }

        @Override
        public CollaborationSession createSession(CollaborationSessionInfo info, ConnectionInitiationCallback cb) throws CollaborationException {
            throw new UnsupportedOperationException("No session factory registered.");
        }

        @Override
        public void openSession(CollaborationSession session, ConnectionInitiationCallback cb) throws CollaborationException {
            throw new UnsupportedOperationException("No session factory registered.");
        }

        @Override
        public void configureSession(CollaborationSession session, ConnectionInitiationCallback cb) throws CollaborationException {
            throw new UnsupportedOperationException("No session factory registered.");
        }

        @Override
        public void sendSessionID(CollaborationSession session, String id, ConnectionInitiationCallback cb) throws CollaborationException {
            throw new UnsupportedOperationException("No session factory registered.");
        }

        @Override
        public void closeSession(CollaborationSession session) throws CollaborationException {
            throw new UnsupportedOperationException("No session factory registered.");
        }
    }
}

