/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session.xmpp;

import com.paterva.maltego.collab.session.CollaborationSessionInfo;
import com.paterva.maltego.collab.session.xmpp.DummySSLSocketFactory;
import com.paterva.maltego.collab.session.xmpp.bosh.BoshConfiguration;
import com.paterva.maltego.collab.ui.PortInfo;
import com.paterva.maltego.util.NormalException;
import java.net.URI;
import java.net.URISyntaxException;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.netbeans.api.keyring.Keyring;
import org.openide.util.NetworkSettings;

public class XMPPConnectionFactory {
    public static XMPPConnection create(CollaborationSessionInfo info) throws URISyntaxException {
        return XMPPConnectionFactory.create(info.getService(), info.getServer(), info.getPortInfo(), info.isDebugSession());
    }

    public static XMPPConnection create(String service, String server, PortInfo portInfo, boolean debug) throws URISyntaxException {
        ProxyInfo proxy = XMPPConnectionFactory.getHttpProxyInfo(server);
        if (proxy == null) {
            proxy = ProxyInfo.forDefaultProxy();
        }
        boolean httpTunnel = portInfo.isBind();
        int port = portInfo.getSelectedPort();
        BoshConfiguration config = httpTunnel ? new BoshConfiguration(server, port, proxy, portInfo.isHttpsBind()) : (portInfo.isAuto() ? new ConnectionConfiguration(service, proxy) : new ConnectionConfiguration(server, port, service, proxy));
        config.setCompressionEnabled(!httpTunnel);
        config.setDebuggerEnabled(debug);
        config.setReconnectionAllowed(false);
        config.setSecurityMode(ConnectionConfiguration.SecurityMode.enabled);
        if (portInfo.isSsl() || portInfo.isHttpsBind()) {
            config.setSocketFactory(new DummySSLSocketFactory());
        }
        config.setSASLAuthenticationEnabled(true);
        config.setRosterLoadedAtLogin(false);
        return new XMPPConnection((ConnectionConfiguration)config);
    }

    private static ProxyInfo getHttpProxyInfo(String server) {
        ProxyInfo proxy = null;
        URI hostUri = URI.create("http://" + server);
        String proxyHost = NetworkSettings.getProxyHost((URI)hostUri);
        if (proxyHost != null && !proxyHost.isEmpty()) {
            String proxyPortStr = NetworkSettings.getProxyPort((URI)hostUri);
            try {
                int proxyPort = Integer.parseInt(proxyPortStr);
                String username = "";
                String password = "";
                String authUser = NetworkSettings.getAuthenticationUsername((URI)hostUri);
                if (authUser != null) {
                    char[] pass;
                    username = authUser;
                    String passKey = NetworkSettings.getKeyForAuthenticationPassword((URI)hostUri);
                    if (passKey != null && (pass = Keyring.read((String)passKey)) != null) {
                        password = String.valueOf(pass);
                    }
                }
                proxy = ProxyInfo.forHttpProxy((String)proxyHost, (int)proxyPort, (String)username, (String)password);
            }
            catch (NumberFormatException ex) {
                NormalException.logStackTrace((Throwable)ex);
            }
        }
        return proxy;
    }
}

