/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session.xmpp.bosh;

import com.paterva.maltego.collab.XmlPullParserUtils;
import com.paterva.maltego.util.NormalException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class BoshDebugProxy {
    private XmlPullParser _parser;
    private boolean _started = false;
    private boolean _stopRequested = false;
    private int _streamDepth = -1;
    private final InputStream _is;

    public BoshDebugProxy(InputStream is) {
        this._is = is;
    }

    public synchronized void start() throws IOException {
        if (!this._started) {
            try {
                this._parser = new MXParser();
                this._parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                this._parser.setInput(this._is, "UTF-8");
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        BoshDebugProxy.this.processClientToServer();
                        BoshDebugProxy.this._started = false;
                        BoshDebugProxy.this._stopRequested = false;
                    }
                });
                thread.setDaemon(true);
                thread.start();
            }
            catch (XmlPullParserException ex) {
                throw new IOException("Error initializing parser", ex);
            }
        }
        this._started = true;
    }

    private void processClientToServer() {
        try {
            int event;
            do {
                if ((event = this._parser.next()) != 2) continue;
                if (BoshDebugProxy.isStreamStart(this._parser)) {
                    System.out.println("STREAM " + this._parser.getDepth());
                    this._streamDepth = this._parser.getDepth();
                    continue;
                }
                System.out.println("start " + this._parser.getDepth() + " " + this._parser.getName());
                if (this._parser.getDepth() != this._streamDepth + 1) continue;
                System.out.println("----- START " + this._parser.getName() + " ------");
                System.out.println(BoshDebugProxy.nodeToString(this._parser));
                System.out.println("-----            ------");
            } while (!this._stopRequested && event != 1);
        }
        catch (XmlPullParserException ex) {
            NormalException.showStackTrace((Throwable)ex);
        }
        catch (EOFException ex) {
            if (!this._stopRequested) {
                NormalException.showStackTrace((Throwable)ex);
            }
        }
        catch (IOException ex) {
            NormalException.showStackTrace((Throwable)ex);
        }
    }

    private static String nodeToString(XmlPullParser parser) throws XmlPullParserException, IOException {
        return XmlPullParserUtils.toString(parser);
    }

    public synchronized void stop() {
        this._stopRequested = true;
    }

    private static boolean isStreamStart(XmlPullParser parser) {
        return "stream".equals(parser.getName()) && "http://etherx.jabber.org/streams".equals(parser.getNamespace());
    }
}

