/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.lucene.bkdtree.LatLonReader;
import org.apache.lucene.bkdtree.LatLonWriter;
import org.apache.lucene.bkdtree.OfflineLatLonReader;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.OfflineSorter;

final class OfflineLatLonWriter
implements LatLonWriter {
    final Path tempFile;
    final byte[] scratchBytes = new byte[20];
    final ByteArrayDataOutput scratchBytesOutput = new ByteArrayDataOutput(this.scratchBytes);
    final OutputStreamDataOutput out;
    final long count;
    private long countWritten;
    private boolean closed;

    public OfflineLatLonWriter(long count) throws IOException {
        this.tempFile = Files.createTempFile(OfflineSorter.getDefaultTempDir(), "size" + count + ".", "", new FileAttribute[0]);
        this.out = new OutputStreamDataOutput((OutputStream)new BufferedOutputStream(Files.newOutputStream(this.tempFile, new OpenOption[0])));
        this.count = count;
    }

    @Override
    public void append(int latEnc, int lonEnc, long ord, int docID) throws IOException {
        this.out.writeInt(latEnc);
        this.out.writeInt(lonEnc);
        this.out.writeLong(ord);
        this.out.writeInt(docID);
        ++this.countWritten;
    }

    @Override
    public LatLonReader getReader(long start) throws IOException {
        assert (this.closed);
        return new OfflineLatLonReader(this.tempFile, start, this.count - start);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.out.close();
        if (this.count != this.countWritten) {
            throw new IllegalStateException("wrote " + this.countWritten + " values, but expected " + this.count);
        }
    }

    @Override
    public void destroy() throws IOException {
        IOUtils.rm((Path[])new Path[]{this.tempFile});
    }

    public String toString() {
        return "OfflineLatLonWriter(count=" + this.count + " tempFile=" + this.tempFile + ")";
    }
}

