/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.types;

import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.FileStore;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Attachment
implements Comparable<Attachment> {
    private final int _id;
    private final FastURL _source;

    public Attachment(int id, FastURL source) {
        this._id = id;
        this._source = source;
    }

    public int getId() {
        return this._id;
    }

    public FastURL getSource() {
        return this._source;
    }

    public String getFileName() {
        try {
            return FileStore.getDefault().get(this._id).getName();
        }
        catch (Exception ex) {
            Logger.getLogger(Attachment.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Attachment other = (Attachment)obj;
        return this._id == other._id;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this._id;
        return hash;
    }

    public String toString() {
        return "Attachment{id=" + this._id + "}";
    }

    @Override
    public int compareTo(Attachment o) {
        return this.getFileName().compareTo(o.getFileName());
    }
}

