/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.types;

import com.paterva.maltego.util.FileUtilities;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;

public class BinaryFile {
    private byte[] _data;
    private String _filename;

    public BinaryFile(String filename, byte[] data) {
        this._filename = filename;
        this._data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BinaryFile create(File file) throws FileNotFoundException, IOException {
        ByteArrayOutputStream os = null;
        FileInputStream is = null;
        InputStreamReader reader = null;
        try {
            os = new ByteArrayOutputStream();
            is = new FileInputStream(file);
            reader = new InputStreamReader(is);
            while (reader.ready()) {
                os.write(reader.read());
            }
            BinaryFile binaryFile = new BinaryFile(file.getName(), os.toByteArray());
            return binaryFile;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public byte[] getData() {
        return this._data;
    }

    public void setData(byte[] data) {
        this._data = data;
    }

    public String getFilename() {
        return this._filename;
    }

    public void setFilename(String filename) {
        this._filename = filename;
    }

    public String getExtension() {
        return FileUtilities.getFileExtension((String)this._filename);
    }
}

