/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.types;

import com.paterva.maltego.typing.types.DateTime;
import java.util.Date;
import java.util.Objects;

public class FixedDateRange {
    private DateTime _fromDate;
    private DateTime _toDate;

    public FixedDateRange(Date fromDate, Date toDate) {
        this(new DateTime(fromDate), new DateTime(toDate));
    }

    public FixedDateRange(DateTime fromDate, DateTime toDate) {
        this.checkDateTime(fromDate, toDate);
        this._fromDate = fromDate;
        this._toDate = toDate;
    }

    public DateTime getFromDate() {
        return this._fromDate;
    }

    public DateTime getToDate() {
        return this._toDate;
    }

    public void setFromDate(DateTime fromDate) {
        this.checkDateTime(fromDate);
        this._fromDate = fromDate;
    }

    public void setToDate(DateTime toDate) {
        this.checkDateTime(toDate);
        this._toDate = toDate;
    }

    private void checkDateTime(DateTime ... dates) {
        for (DateTime date : dates) {
            if (date != null && date.getDate() != null) continue;
            throw new IllegalArgumentException("FixedDateRange: from/to DateTime/Date values may not be null");
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + Objects.hashCode(this._fromDate);
        hash = 23 * hash + Objects.hashCode(this._toDate);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FixedDateRange other = (FixedDateRange)obj;
        if (!Objects.equals(this._fromDate, other._fromDate)) {
            return false;
        }
        return Objects.equals(this._toDate, other._toDate);
    }
}

