/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tabular.transforms.run.v2;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.graph.store.GraphFactory;
import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.tabular.transforms.run.v2.AbstractTabularTransformRunnerV2;
import com.paterva.maltego.tabular.transforms.run.v2.graph.TabularTransformGraphBuilderV2;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.gen.TransformSource;
import com.paterva.maltego.transform.gen.TransformSourceRegistry;
import com.paterva.maltego.transforms.tabular.data.TabularTransform;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.Args;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.netbeans.api.progress.ProgressHandle;

public class TabularTransformRunnerV2
extends AbstractTabularTransformRunnerV2 {
    private static final boolean REVERSE_REVERSE_LINK_DIRECTION = false;

    public TabularTransformRunnerV2(GraphID graphID, EntityFactory factory, EntityRegistry registry, TransformDescriptor transform) {
        super(graphID, factory, registry, transform);
        Args.notNull((Object)graphID, (String)"graphID");
        Args.notNull((Object)factory, (String)"factory");
        Args.notNull((Object)registry, (String)"registry");
        Args.notNull((Object)transform, (String)"transform");
    }

    @Override
    protected Set<MaltegoEntity> runTransform(MaltegoEntity inputEntity, ProgressHandle handle) throws Exception {
        Args.notNull((Object)inputEntity, (String)"inputEntity");
        Args.notNull((Object)handle, (String)"handle");
        SourceAndTransform sourceAndTransform = this.getSourceAndTransform().orElseThrow(() -> new IllegalStateException("Transform not found: " + this.getTransform().getDisplayName()));
        TabularTransformSource txSource = sourceAndTransform.getSource();
        TabularTransform tabularTransform = sourceAndTransform.getTransform();
        TabularGraph mappings = MappingRegistry.getDefault().get(txSource.getTabularGraphName());
        if (mappings == null) {
            throw new IllegalStateException("Tabular graph not found for source: " + txSource.getDisplayName());
        }
        List<File> files = this.getFiles(txSource);
        GraphID newGraphID = GraphFactory.getDefault().createInvisibleInMemoryGraph();
        List links = tabularTransform.getLinks(mappings);
        TabularTransformGraphBuilderV2 builder = new TabularTransformGraphBuilderV2(newGraphID, mappings, files, handle, links, inputEntity, tabularTransform.isReverse());
        builder.build();
        Set entities = GraphStoreHelper.getMaltegoEntities((GraphID)newGraphID);
        return entities;
    }

    private void addReverseDirectionProperty(Set<MaltegoEntity> maltegoEntities) {
        Args.notNull(maltegoEntities, (String)"maltegoEntities");
        PropertyDescriptor prop = new PropertyDescriptor(String.class, "link#maltego.link.direction");
        for (MaltegoEntity entity : maltegoEntities) {
            entity.setValue(prop, (Object)"output-to-input");
        }
    }

    private Optional<SourceAndTransform> getSourceAndTransform() {
        String transformName = this.getTransform().getName();
        for (TransformSource ds : TransformSourceRegistry.getInstance().getAll()) {
            TabularTransformSource tds = (TabularTransformSource)ds;
            Optional tabularTransform = tds.getTabularTransform(transformName);
            if (!tabularTransform.isPresent()) continue;
            return Optional.of(new SourceAndTransform(tds, (TabularTransform)tabularTransform.get()));
        }
        return Optional.empty();
    }

    private static class SourceAndTransform {
        private final TabularTransformSource source;
        private final TabularTransform transform;

        public SourceAndTransform(TabularTransformSource source, TabularTransform transform) {
            Args.notNull((Object)source, (String)"source");
            Args.notNull((Object)transform, (String)"transform");
            this.source = source;
            this.transform = transform;
        }

        public TabularTransformSource getSource() {
            return this.source;
        }

        public TabularTransform getTransform() {
            return this.transform;
        }
    }
}

