/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.forms;

import com.paterva.maltego.core.OverlayDescriptor;
import com.paterva.maltego.core.OverlayDescriptorSet;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.entity.manager.forms.DisplayInfoForm;
import com.paterva.maltego.entity.manager.forms.PropertyTypes;
import com.paterva.maltego.imgfactoryapi.ImageFactory;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.DataEditController;
import java.awt.Image;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openide.WizardDescriptor;

public class DisplayInfoFormController
extends DataEditController<DisplayInfoForm, MaltegoEntitySpec>
implements WizardDescriptor.FinishablePanel {
    private static final DisplayDescriptor dummyProperty = new DisplayDescriptor(DisplayInfoFormController.class, "<default>", "<Get from inherited type>");
    private static final DisplayDescriptor imgDummyProperty = new DisplayDescriptor(DisplayInfoFormController.class, "<default>", "<Use entity type icon>");
    private static final DisplayDescriptor inheritProperty = new DisplayDescriptor(DisplayInfoFormController.class, "<Inherited>", "<Inherited>");
    private static final Vector<String> propertyTypes;
    private static final Map<OverlayDescriptor.Type, String> propertyTypeMap;
    private static final Map<Integer, OverlayDescriptor.Position> modelViewMap;
    private boolean _displayDescriptionInPanel = false;

    public DisplayInfoFormController(boolean displayDescriptionInPanel) {
        super("entitySpec");
        this.setName("Display Settings");
        this.setDescription("Select which properties to display in the graph view.");
        this._displayDescriptionInPanel = displayDescriptionInPanel;
    }

    protected String getFirstError(DisplayInfoForm component) {
        return null;
    }

    protected DisplayInfoForm createComponent() {
        DisplayInfoForm f = new DisplayInfoForm(this._displayDescriptionInPanel);
        f.addChangeListener(this.changeListener());
        return f;
    }

    protected void setData(DisplayInfoForm component, MaltegoEntitySpec data) {
        this.setDisplayInfo(component, data);
        this.setOverlayProperties(component, data);
        this.setOverlayPreview(component, data);
    }

    void setDisplayInfo(DisplayInfoForm component, MaltegoEntitySpec data) {
        Optional<DisplayDescriptor> propOpt;
        EntityRegistry registry = EntityRegistry.getDefault();
        List properties = data.getBaseEntitySpecs().stream().filter(spec -> !spec.equals("maltego.Unknown")).map(spec -> InheritanceHelper.getAggregatedProperties((SpecRegistry)registry, (String)spec)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        properties.addAll(data.getProperties());
        Vector comboProperties = properties.stream().distinct().collect(Collectors.toCollection(Vector::new));
        component.setValueProperties(comboProperties);
        if (data.getValueProperty() != null) {
            component.setValueProperty(data.getValueProperty());
        }
        component.setDisplayValueProperties(comboProperties);
        String dispExpr = data.getDisplayValueExpression();
        dispExpr = StringUtilities.escapeNewlines((String)dispExpr);
        if (dispExpr.isEmpty() && !properties.isEmpty()) {
            dispExpr = ((DisplayDescriptor)properties.get(0)).getName();
        }
        component.setDisplayValueObject((propOpt = this.getProperty(comboProperties, dispExpr)).isPresent() ? propOpt.get() : dispExpr);
        Vector imageProperties = PropertyTypes.getImageProperties(comboProperties, Vector::new);
        imageProperties.insertElementAt(imgDummyProperty, 0);
        component.setImageProperties(imageProperties);
        data.getImageExpression().ifPresent(imgExpr -> {
            Optional<DisplayDescriptor> prop = this.getProperty(imageProperties, imgExpr = StringUtilities.escapeNewlines((String)imgExpr));
            component.setImageObject(prop.isPresent() ? prop.get() : imgExpr);
        });
    }

    void setOverlayProperties(DisplayInfoForm component, MaltegoEntitySpec data) {
        EntityRegistry registry = EntityRegistry.getDefault();
        List properties = data.getBaseEntitySpecs().stream().filter(spec -> !spec.equals("maltego.Unknown")).map(spec -> InheritanceHelper.getAggregatedProperties((SpecRegistry)registry, (String)spec)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        properties.addAll(data.getProperties());
        Vector comboProperties = properties.stream().distinct().collect(Collectors.toCollection(Vector::new));
        comboProperties.insertElementAt(inheritProperty, 0);
        component.setOverlayProperties(comboProperties);
        component.setOverlayTypes(propertyTypes);
        OverlayDescriptorSet overlays = data.getOverlaySet();
        if (overlays == null || overlays.isEmpty()) {
            return;
        }
        Map<String, DisplayDescriptor> propertyLookup = comboProperties.stream().collect(Collectors.toMap(PropertyDescriptor::getName, property -> property));
        for (Map.Entry<Integer, OverlayDescriptor.Position> tuple : modelViewMap.entrySet()) {
            Integer location = tuple.getKey();
            OverlayDescriptor.Position modelPosition = tuple.getValue();
            List overlayList = overlays.stream().filter(overlay -> modelPosition.equals((Object)overlay.getPosition())).collect(Collectors.toList());
            for (OverlayDescriptor overlay2 : overlayList) {
                String propertyName = overlay2.getPropertyName();
                DisplayDescriptor property2 = propertyLookup.get(propertyName);
                if (property2 == null) {
                    property2 = new DisplayDescriptor(String.class, propertyName);
                }
                OverlayDescriptor.Type type = overlay2.getType();
                String overlayType = propertyTypeMap.get(type);
                component.setPropertyAndType(location, property2, overlayType);
            }
        }
    }

    void setOverlayPreview(DisplayInfoForm component, MaltegoEntitySpec data) {
        Image image = data.getLargeIcon();
        if (image == null) {
            String imageResource = data.getLargeIconResource();
            if (imageResource == null) {
                imageResource = data.getSmallIconResource();
            }
            if (imageResource == null) {
                component.setOverlayImage(null);
                return;
            }
            image = ImageFactory.getDefault().getImage((Object)imageResource, null);
        }
        component.setOverlayImage(image);
    }

    private boolean isInheritingSpec(MaltegoEntitySpec data) {
        List baseEntities = data.getBaseEntitySpecs();
        return baseEntities != null && baseEntities.size() > 0 && (baseEntities.size() > 1 || !((String)baseEntities.get(0)).equals("maltego.Unknown"));
    }

    protected void updateData(DisplayInfoForm component, MaltegoEntitySpec data) {
        this.updateDisplayInfoData(component, data);
        this.updateOverlayMapping(component, data);
    }

    void updateDisplayInfoData(DisplayInfoForm component, MaltegoEntitySpec data) {
        DisplayDescriptor valueDescriptor = component.getValueProperty();
        if (valueDescriptor != null) {
            if (valueDescriptor.getType() == DisplayInfoFormController.class) {
                data.setValueProperty(null);
            } else {
                data.setValueProperty(valueDescriptor);
            }
        }
        Object dispExprObj = component.getDisplayValueObject();
        String dispExpr = this.getExpression(dispExprObj);
        data.setDisplayValueExpression(dispExpr);
        Object imgExprObj = component.getImageObject();
        String imgExpr = this.getExpression(imgExprObj);
        data.setImageExpression(imgExpr);
    }

    void updateOverlayMapping(DisplayInfoForm component, MaltegoEntitySpec data) {
        OverlayDescriptorSet overlays = new OverlayDescriptorSet();
        data.setOverlaySet(overlays);
        for (Map.Entry<Integer, OverlayDescriptor.Position> tuple : modelViewMap.entrySet()) {
            Integer location = tuple.getKey();
            Object property = component.getOverlayProperty(location);
            String type = component.getOverlayType(location);
            String propExpression = this.getExpression(property);
            if (propExpression == null || type == null) continue;
            OverlayDescriptor.Type modelType = OverlayDescriptor.Type.valueOfType((String)type);
            OverlayDescriptor.Position modelPosition = tuple.getValue();
            OverlayDescriptor overlay = new OverlayDescriptor(propExpression, modelPosition.code, modelType.type);
            overlays.add(overlay);
        }
    }

    private String getExpression(Object exprObj) {
        if (exprObj == null) {
            return null;
        }
        if (dummyProperty.equals(exprObj) || imgDummyProperty.equals(exprObj) || inheritProperty.equals(exprObj)) {
            return null;
        }
        if (exprObj instanceof DisplayDescriptor) {
            return ((DisplayDescriptor)exprObj).getName();
        }
        return StringUtilities.unescapeNewlines((String)exprObj.toString());
    }

    public boolean isFinishPanel() {
        return true;
    }

    private Optional<DisplayDescriptor> getProperty(Vector<DisplayDescriptor> properties, String name) {
        return properties.stream().filter(prop -> name.equals(prop.getName())).findFirst();
    }

    static {
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put(OverlayDescriptor.Type.IMAGE, "Image");
        map.put(OverlayDescriptor.Type.TEXT, "Text");
        map.put(OverlayDescriptor.Type.COLOUR, "Color");
        propertyTypeMap = Collections.unmodifiableMap(map);
        propertyTypes = Stream.of("Image", "Text", "Color").collect(Collectors.toCollection(Vector::new));
        map = new HashMap();
        map.put(0, (String)OverlayDescriptor.Position.NORTH);
        map.put(1, (String)OverlayDescriptor.Position.NORTH_WEST);
        map.put(3, (String)OverlayDescriptor.Position.WEST);
        map.put(6, (String)OverlayDescriptor.Position.SOUTH_WEST);
        map.put(8, (String)OverlayDescriptor.Position.SOUTH);
        modelViewMap = Collections.unmodifiableMap(map);
    }
}

