/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.imex;

import com.paterva.entity.serializer.EntityCategoryEntry;
import com.paterva.entity.serializer.MaltegoEntityEntry;
import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.MaltegoArchiveWriter;
import com.paterva.maltego.customicons.imex.IconDescriptor;
import com.paterva.maltego.customicons.imex.IconFileEntry;
import com.paterva.maltego.customicons.imex.IconMetadata;
import com.paterva.maltego.customicons.imex.IconMetadataEntry;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.manager.imex.EntityConfig;
import com.paterva.maltego.imgfactory.icons.IconLayerRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.imgfactoryapi.VirtualIcon;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigExporter;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.IconSize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.openide.filesystems.FileObject;

public class EntityExporter
extends ConfigExporter {
    public Config getCurrentConfig() {
        String[] categoryNames = EntityRegistry.getDefault().allCategories();
        Collection allEntities = EntityRegistry.getDefault().getAllVisible();
        if (categoryNames.length > 0) {
            return new EntityConfig(categoryNames, allEntities);
        }
        return null;
    }

    public int saveConfig(MaltegoArchiveWriter writer, Config config) throws IOException {
        IconFileEntry entry;
        EntityConfig entityConfig = (EntityConfig)config;
        List<String> selectedCategories = entityConfig.getSelectedCategories();
        ArrayList<String> names = new ArrayList<String>(selectedCategories.size());
        for (String string : selectedCategories) {
            String name = FileUtilities.createUniqueLegalFilename(names, (String)string);
            names.add(name);
            writer.write((Entry)new EntityCategoryEntry(string, name));
        }
        List<MaltegoEntitySpec> selectedEntities = entityConfig.getSelectedEntities();
        for (MaltegoEntitySpec maltegoEntitySpec : selectedEntities) {
            writer.write((Entry)new MaltegoEntityEntry(maltegoEntitySpec));
        }
        IconLayerRegistry iconLayerRegistry = IconLayerRegistry.getDefault();
        HashSet<String> iconNames = new HashSet<String>();
        for (MaltegoEntitySpec maltegoEntitySpec : selectedEntities) {
            iconNames.add(maltegoEntitySpec.getSmallIconResource());
            iconNames.add(maltegoEntitySpec.getLargeIconResource());
        }
        ArrayList descriptors = new ArrayList();
        ArrayList metadatas = new ArrayList();
        for (String iconName : iconNames) {
            if (iconName == null) continue;
            VirtualIcon.parse((String)iconName).flatMap(arg_0 -> ((IconLayerRegistry)iconLayerRegistry).findRegistryIcon(arg_0)).ifPresent(icon -> {
                for (IconSize size : IconSize.values()) {
                    descriptors.add(this.createDescriptor(iconRegistry, (RegistryIcon)icon, size));
                }
                metadatas.add(new IconMetadata(icon));
            });
        }
        for (IconDescriptor iconDescriptor : descriptors) {
            entry = new IconFileEntry(iconDescriptor);
            writer.write((Entry)entry);
        }
        for (IconMetadata metadata : metadatas) {
            entry = new IconMetadataEntry(metadata);
            writer.write((Entry)entry);
        }
        return selectedEntities.size();
    }

    private IconDescriptor createDescriptor(IconLayerRegistry iconRegistry, RegistryIcon icon, IconSize size) {
        FileObject fileObject = iconRegistry.getFileObject(icon, size);
        return new IconDescriptor(fileObject, icon.getCategory(), icon.getName(), size);
    }
}

