/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.api.registry;

import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.seeds.api.registry.HubSeedSettingsAction;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.descriptor.TransformSeedRepository;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DataSources;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

class DefaultHubSeedSettings
extends HubSeedSettings {
    private static final Logger LOG = Logger.getLogger(DefaultHubSeedSettings.class.getName());
    private final TransformSeedRepository _repo;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private final HubSeedRegistry _registry = HubSeedRegistry.getDefault();

    public DefaultHubSeedSettings(TransformSeedRepository repo) {
        this._repo = repo;
    }

    @Override
    public boolean isInstalled(HubSeedDescriptor seed) {
        List<TransformSeed> transformSeeds = this._registry.getTransformSeeds(seed);
        boolean enabled = false;
        for (TransformSeed transformSeed : transformSeeds) {
            if (transformSeed.isEnabled()) {
                enabled = true;
                continue;
            }
            enabled = false;
            break;
        }
        return enabled;
    }

    @Override
    public void setInstalled(HubSeedDescriptor seed, boolean installed) {
        List<TransformSeed> transformSeeds = this._registry.getTransformSeeds(seed);
        boolean enabledChange = false;
        for (TransformSeed transformSeed : transformSeeds) {
            if (transformSeed.isEnabled() == installed) continue;
            transformSeed.setEnabled(installed);
            this.save(transformSeed);
            enabledChange = true;
        }
        if (enabledChange) {
            this._changeSupport.firePropertyChange("maltego.hub.installed", null, seed);
        }
    }

    @Override
    public DisplayDescriptorCollection getGlobalTransformProperties(HubSeedDescriptor seed) {
        TransformSeed transformSeed = this._registry.getTransformSeed(seed);
        return transformSeed != null ? transformSeed.getGlobalTxProperties() : new DisplayDescriptorList();
    }

    @Override
    public DisplayDescriptorCollection getGlobalTransformProperties(HubSeedDescriptor seed, TransformDefinition transform, boolean authOnly) {
        DisplayDescriptorCollection txProps;
        DisplayDescriptorList properties = new DisplayDescriptorList();
        DisplayDescriptorCollection seedProps = this.getGlobalTransformProperties(seed);
        if (seedProps != null && (txProps = transform.getProperties()) != null) {
            for (DisplayDescriptor seedProp : seedProps) {
                TransformPropertyDescriptor seedTpd;
                if (seedProp == null || !txProps.contains((seedTpd = (TransformPropertyDescriptor)seedProp).getName()) || authOnly && !seedTpd.isAuth()) continue;
                properties.add((DisplayDescriptor)seedTpd);
            }
        }
        return properties;
    }

    @Override
    public DisplayDescriptorCollection getGlobalTransformProperties(TransformDefinition transform) {
        DisplayDescriptorList properties = new DisplayDescriptorList();
        for (HubSeedDescriptor hubSeed : HubSeedRegistry.getDefault().getHubSeeds((TransformDescriptor)transform)) {
            for (DisplayDescriptor prop : this.getGlobalTransformProperties(hubSeed, transform, false)) {
                DisplayDescriptor property;
                if (prop == null || properties.contains(prop.getName()) || (property = transform.getProperties().get(prop.getName())) == null) continue;
                properties.add(property);
            }
        }
        return properties;
    }

    @Override
    public DataSource getGlobalTransformSettings(HubSeedDescriptor seed) {
        return new HubSettingsDataSource(seed);
    }

    @Override
    public void save(HubSeedDescriptor seed) {
        if (!seed.getGrantedHubSeedUrls().isEmpty()) {
            List<TransformSeed> transformSeeds = this._registry.getTransformSeeds(seed);
            for (TransformSeed transformSeed : transformSeeds) {
                this.save(transformSeed);
            }
        }
    }

    @Override
    public void show(HubSeedDescriptor seed) {
        HubSeedSettingsAction action = (HubSeedSettingsAction)Lookup.getDefault().lookup(HubSeedSettingsAction.class);
        if (action != null) {
            action.show(seed);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    private void save(TransformSeed transformSeed) {
        this._repo.add(transformSeed);
    }

    private class HubSettingsDataSource
    implements DataSource {
        private final HubSeedDescriptor _hubSeed;

        public HubSettingsDataSource(HubSeedDescriptor hubSeed) {
            this._hubSeed = hubSeed;
        }

        public Object getValue(PropertyDescriptor descriptor) {
            return this.getDelegate().getValue(descriptor);
        }

        public void setValue(PropertyDescriptor descriptor, Object value) {
            DataSources.Map delegate = this.getDelegate();
            this.setValue((DataSource)delegate, descriptor, value);
        }

        public void clear() {
            DataSources.Map delegate = this.getDelegate();
            for (PropertyDescriptor descriptor : delegate.keySet()) {
                this.setValue((DataSource)delegate, descriptor, null);
            }
            delegate.clear();
        }

        void setValue(DataSource delegate, PropertyDescriptor descriptor, Object value) {
            Object oldValue = delegate.getValue(descriptor);
            if (!Utilities.compareObjects((Object)oldValue, (Object)value)) {
                for (TransformSeed transformSeed : this.getTransformSeeds()) {
                    DataSources.Map delegateInner = transformSeed.getGlobalTxSettings();
                    delegateInner.setValue(descriptor, value);
                }
                DefaultHubSeedSettings.this._changeSupport.firePropertyChange(descriptor.getName(), oldValue, value);
            }
        }

        private DataSources.Map getDelegate() {
            List<TransformSeed> transformSeeds = this.getTransformSeeds();
            TransformSeed transformSeed = transformSeeds.isEmpty() ? null : transformSeeds.get(0);
            return transformSeed.getGlobalTxSettings();
        }

        private List<TransformSeed> getTransformSeeds() {
            return DefaultHubSeedSettings.this._registry.getTransformSeeds(this._hubSeed);
        }

        private void printTransformSeedGlobalTxSettings() {
            for (TransformSeed transformSeed : this.getTransformSeeds()) {
                DataSources.Map delegate = transformSeed.getGlobalTxSettings();
                for (PropertyDescriptor propertyDescriptor : delegate.keySet()) {
                    LOG.log(Level.FINE, "Name: {0}, Display: {1}, Value: {2}, Description: {3}", new Object[]{propertyDescriptor.getName(), propertyDescriptor.getDisplayName(), delegate.getValue(propertyDescriptor), propertyDescriptor.getDescription()});
                }
            }
        }
    }
}

