/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.pandora;

import com.paterva.graph.store.pandora.Bundle;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.pinkmatter.pandora.PandoraConnection;
import com.pinkmatter.pandora.PandoraQuery;
import com.pinkmatter.pandora.PandoraQueryResult;
import com.pinkmatter.pandora.PandoraSearch;
import com.pinkmatter.pandora.PandoraStore;
import com.pinkmatter.pandora.lucene.PandoraLuceneFactory;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;

public class TestPandoraAction
extends TopGraphAction {
    private static Random _rand = new Random();

    public String getName() {
        return Bundle.CTL_TestPandoraAction();
    }

    protected void actionPerformed(TopComponent tc) {
        this.test2();
    }

    private void test2() {
        PandoraLuceneFactory factory = new PandoraLuceneFactory();
        File storeDir = new File("C:\\delme\\store");
        for (File file : storeDir.listFiles()) {
            file.delete();
        }
        try (PandoraConnection conn = factory.createFileConnection(storeDir);){
            long startID;
            PandoraStore store = factory.createStore(conn, false, false);
            PandoraSearch searcher = factory.createSearcher(conn, true);
            for (long i = startID = -6981233094763241600L; i < startID + 1000L; ++i) {
                if (_rand.nextBoolean() && _rand.nextBoolean() && _rand.nextBoolean()) {
                    try {
                        Thread.sleep(_rand.nextInt(100));
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                System.out.println(i - startID + " " + System.currentTimeMillis() + " putEntity " + i + " thread = " + Thread.currentThread());
                Map<String, Object> map = this.createEntityMap();
                store.add(i, map);
                PandoraQuery query = searcher.query().keys(new long[]{i}).exclude("properties").exclude("weight").exclude("imagePropName").exclude("valueStr").exclude("valuePropName").exclude("displayPropName").exclude("displayInfo");
                long count = query.count();
                if (count == 1L) continue;
                boolean bl = false;
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void test1() throws IllegalStateException {
        try {
            PandoraLuceneFactory factory = new PandoraLuceneFactory();
            File storeDir = new File("C:\\delme\\store");
            for (File file : storeDir.listFiles()) {
                file.delete();
            }
            PandoraConnection conn = factory.createFileConnection(storeDir);
            PandoraStore store = factory.createStore(conn, false, false);
            PandoraSearch searcher = factory.createSearcher(conn, true);
            Random random = new Random();
            int innerCount = 20;
            HashSet<Long> ids = new HashSet<Long>();
            for (int i = 100; i < 2000; ++i) {
                for (long j = (long)(i * innerCount); j < (long)(i * innerCount + innerCount); ++j) {
                    try {
                        Long id = random.nextLong();
                        Map<String, Object> map = this.createEntityMap();
                        store.add(id.longValue(), map);
                        ids.add(id);
                        continue;
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                for (Long id : ids) {
                    PandoraQuery query = searcher.query().keys(new long[]{id}).exclude("properties").exclude("weight").exclude("imagePropName").exclude("valueStr").exclude("valuePropName").exclude("displayPropName").exclude("displayInfo");
                    PandoraQueryResult pandoraQueryResult = query.list();
                }
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public Map<String, Object> createEntityMap() {
        LinkedHashMap<String, Object> entityMap = new LinkedHashMap<String, Object>();
        if (_rand.nextBoolean()) {
            entityMap.put("id", TestPandoraAction.randomStr());
        }
        if (_rand.nextBoolean()) {
            entityMap.put("type", TestPandoraAction.randomStr());
        }
        if (_rand.nextBoolean()) {
            entityMap.put("valueStr", TestPandoraAction.randomStr());
        }
        if (_rand.nextBoolean()) {
            entityMap.put("displayValueStr", TestPandoraAction.randomStr());
        }
        if (_rand.nextBoolean()) {
            entityMap.put("hasAttachments", false);
        }
        if (_rand.nextBoolean()) {
            entityMap.put("weight", 35);
        }
        LinkedHashMap propertiesMap = new LinkedHashMap();
        LinkedHashMap<String, String> prop0Map = new LinkedHashMap<String, String>();
        prop0Map.put("displayName", TestPandoraAction.randomStr());
        prop0Map.put("value", TestPandoraAction.randomStr());
        prop0Map.put("type", "string");
        if (_rand.nextBoolean()) {
            propertiesMap.put("fqdn", prop0Map);
        }
        LinkedHashMap<String, Object> prop1Map = new LinkedHashMap<String, Object>();
        prop1Map.put("displayName", TestPandoraAction.randomStr());
        prop1Map.put("value", false);
        prop1Map.put("type", "boolean");
        if (_rand.nextBoolean()) {
            propertiesMap.put(TestPandoraAction.randomStr(), prop1Map);
        }
        LinkedHashMap<String, Object> prop2Map = new LinkedHashMap<String, Object>();
        prop2Map.put("displayName", "Ports");
        prop2Map.put("value", 80);
        prop2Map.put("type", "int[]");
        if (_rand.nextBoolean()) {
            propertiesMap.put(TestPandoraAction.randomStr(), prop2Map);
        }
        LinkedHashMap<String, String> prop3Map = new LinkedHashMap<String, String>();
        prop3Map.put("displayName", "URLs");
        prop3Map.put("value", TestPandoraAction.randomStr());
        prop3Map.put("type", "string");
        if (_rand.nextBoolean()) {
            propertiesMap.put("URLS", prop3Map);
        }
        if (_rand.nextBoolean()) {
            entityMap.put("properties", propertiesMap);
        }
        LinkedHashMap<String, String> displayInfoMap = new LinkedHashMap<String, String>();
        displayInfoMap.put("Snippet(s):", TestPandoraAction.randomStr() + TestPandoraAction.randomStr() + TestPandoraAction.randomStr() + TestPandoraAction.randomStr() + TestPandoraAction.randomStr() + TestPandoraAction.randomStr());
        if (_rand.nextBoolean()) {
            entityMap.put("displayInfo", displayInfoMap);
        }
        return entityMap;
    }

    public static String randomStr() {
        return Long.toString(_rand.nextLong());
    }
}

