/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.attachments;

import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.util.FileStore;
import java.awt.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class AttachmentsOpenAction
extends NodeAction {
    public String getName() {
        return "Open";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(Node[] activatedNodes) {
        List<Attachment> atts = this.getAttachments(activatedNodes);
        Desktop desktop = Desktop.getDesktop();
        for (Attachment att : atts) {
            File file = null;
            try {
                file = FileStore.getDefault().get(att.getId());
                try {
                    desktop.open(file);
                }
                catch (IOException ex) {
                    this.showCouldNotOpen(ex, file.getName());
                }
            }
            catch (FileNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public boolean enable(Node[] activatedNodes) {
        return Desktop.isDesktopSupported() && !this.getAttachments(activatedNodes).isEmpty();
    }

    private List<Attachment> getAttachments(Node[] activatedNodes) {
        ArrayList<Attachment> atts = new ArrayList<Attachment>();
        for (Node node : activatedNodes) {
            Attachment att = (Attachment)node.getLookup().lookup(Attachment.class);
            if (att == null) continue;
            atts.add(att);
        }
        return atts;
    }

    private void showCouldNotOpen(IOException ex, String filename) {
        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("The JVM was unable to find an application associated with the \"Open\" command for the file: " + filename), 0);
        msg.setTitle("Could not open file");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
    }
}

