/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.form;

import com.paterva.maltego.typing.Group;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.editing.form.GroupFactory;
import com.paterva.maltego.typing.editing.form.PanelGroupFactory;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Container;
import java.util.HashMap;
import java.util.Map;

class DefaultGroupFactory {
    private GroupDefinitions _groupDefs;
    private GroupFactory _factoryDelegate;
    private Map<String, Container> _groups;

    public DefaultGroupFactory(GroupDefinitions groups) {
        this(groups, new PanelGroupFactory());
    }

    public DefaultGroupFactory(GroupDefinitions groups, GroupFactory delegate) {
        this._groupDefs = groups;
        this._factoryDelegate = delegate;
        this._groups = new HashMap<String, Container>();
    }

    public Container createGroup(String groupName) {
        if (StringUtilities.isNullOrEmpty((String)groupName)) {
            return this._factoryDelegate.createGroup("", "", "");
        }
        Container set = this._groups.get(groupName);
        if (set == null) {
            set = this.createGroup(groupName);
            this._groups.put(groupName, set);
        }
        return set;
    }

    public Container createNewGroup(String groupName) {
        Group group;
        Container container = StringUtilities.isNullOrEmpty((String)groupName) ? this._factoryDelegate.createGroup("", "", "") : ((group = this._groupDefs.getTopLevelGroups().get(groupName)) == null ? this._factoryDelegate.createGroup(groupName, groupName, "") : this._factoryDelegate.createGroup(group.getName(), group.getDisplayName(), group.getDescription()));
        return container;
    }
}

