/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid.editors;

import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.editing.propertygrid.editors.InplacePropertyEditor;
import com.paterva.maltego.typing.editing.propertygrid.editors.InplacePropertyEditorSupport;
import com.paterva.maltego.typing.editors.OptionItemCollection;
import com.paterva.maltego.util.ui.CheckList;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Array;
import java.text.Format;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.explorer.propertysheet.InplaceEditor;

class CheckListPropertyEditor
extends InplacePropertyEditorSupport {
    private OptionItemCollection _items;
    private CheckList _checkList;
    private boolean _allowAdding = false;

    public CheckListPropertyEditor(Class type, Format format, OptionItemCollection items) {
        super(type, format);
        this._items = items;
    }

    @Override
    public Component getCustomEditor() {
        if (this._checkList == null) {
            this._checkList = new CheckList((Object[])this._items.toArray());
            this._checkList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    OptionItemCollection.OptionItem[] selectedItems = (OptionItemCollection.OptionItem[])Converter.changeArrayType((Object)CheckListPropertyEditor.this._checkList.getSelectedItems(), OptionItemCollection.OptionItem.class);
                    CheckListPropertyEditor.this.setValue(CheckListPropertyEditor.this.itemsToValues(selectedItems));
                }
            });
        }
        Object[] values = (Object[])this.getValue();
        this._checkList.setSelectedItems((Object[])this.valuesToItems(values));
        return new JScrollPane((Component)this._checkList);
    }

    private OptionItemCollection.OptionItem[] valuesToItems(Object[] values) {
        ArrayList<OptionItemCollection.OptionItem> items = new ArrayList<OptionItemCollection.OptionItem>();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                OptionItemCollection.OptionItem item = this._items.getItem(values[i]);
                if (item == null) {
                    if (!this.allowAdding()) continue;
                    continue;
                }
                items.add(item);
            }
        }
        return items.toArray(new OptionItemCollection.OptionItem[items.size()]);
    }

    private Object[] itemsToValues(OptionItemCollection.OptionItem[] items) {
        Object[] values = (Object[])Array.newInstance(Converter.getReferenceType((Class)this._items.getType()), items.length);
        for (int i = 0; i < items.length; ++i) {
            values[i] = this._items.getValue(items[i]);
        }
        return values;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    public boolean allowAdding() {
        return this._allowAdding;
    }

    public void setAllowAdding(boolean allowAdding) {
    }

    @Override
    protected InplaceEditor createEditor() {
        return new TextBoxInplaceEditor();
    }

    private class TextBoxInplaceEditor
    extends InplacePropertyEditor<JTextField> {
        public TextBoxInplaceEditor() {
            super(new JTextField());
            ((JTextField)this.getEditorControl()).setSelectionColor(Color.lightGray);
            ((JTextField)this.getEditorControl()).setEditable(false);
        }

        public Object getValue() {
            return ((JTextField)this.getEditorControl()).getText();
        }

        public void setValue(Object object) {
            ((JTextField)this.getEditorControl()).setText(this.toString(object));
        }

        @Override
        protected void reset(Object value) {
            if (value != null) {
                ((JTextField)this.getEditorControl()).setText(this.toString(value));
            }
        }

        private String toString(Object value) {
            return Converter.convertTo((Object)value, (Class)CheckListPropertyEditor.this.getType());
        }
    }
}

