/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid.editors;

import com.paterva.maltego.typing.editing.propertygrid.editors.InplacePropertyEditor;
import com.paterva.maltego.typing.editing.propertygrid.editors.InplacePropertyEditorSupport;
import java.awt.Color;
import java.util.Date;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXMonthView;
import org.openide.explorer.propertysheet.InplaceEditor;

class DatePropertyEditor
extends InplacePropertyEditorSupport {
    public DatePropertyEditor() {
        super(Date.class, null);
    }

    @Override
    public InplaceEditor createEditor() {
        return new DateInplaceEditor();
    }

    private static class DateInplaceEditor
    extends InplacePropertyEditor<JXDatePicker> {
        public DateInplaceEditor() {
            super(new JXDatePicker());
            JXDatePicker editorControl = (JXDatePicker)this.getEditorControl();
            editorControl.setFormats(new String[]{"yyyy-MM-dd"});
            JXMonthView mv = editorControl.getMonthView();
            mv.setFirstDayOfWeek(2);
            Color weekendColor = UIManager.getLookAndFeelDefaults().getColor("JXMonthViewMod.weekendForeground");
            mv.setDayForeground(7, weekendColor);
            mv.setDayForeground(1, weekendColor);
        }

        public Object getValue() {
            return ((JXDatePicker)this.getEditorControl()).getDate();
        }

        public void setValue(Object object) {
            ((JXDatePicker)this.getEditorControl()).setDate((Date)object);
        }

        @Override
        public void reset(Object value) {
            this.setValue(value);
        }
    }
}

