/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.recovery.ui;

import com.maltego.recovery.ui.BackupMetadata;
import com.paterva.maltego.archive.mtz.BackupFileEntry;
import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.GraphFileType;
import com.paterva.maltego.archive.mtz.MaltegoBackupWriter;
import com.paterva.maltego.archive.mtz.MaltegoRecoveryWriter;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.GraphStoreCache;
import com.paterva.maltego.mtgx.imex.MtgxSerializer;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.Exceptions;

public class BackupSerializer {
    private static final Logger LOG = Logger.getLogger(BackupSerializer.class.getName());
    private final GraphID graphID;
    private final GraphFileType fileType;
    private final BackupMetadata metadata;

    public BackupSerializer(GraphID graphID, GraphFileType fileType) {
        this.graphID = graphID;
        this.fileType = fileType;
        this.metadata = new BackupMetadata(graphID, fileType);
    }

    public void setGraphName(String name) {
        this.metadata.changeName(name);
        LOG.log(Level.INFO, "Setting graph name for backup scheduler for graph: {0} - {1}", new Object[]{this.graphID.toString(), name});
    }

    public void setGraphFile(File file) {
        this.metadata.changeFilepath(file);
        LOG.log(Level.INFO, "Setting filepath for backup scheduler for graph: {0} - {1}", new Object[]{this.graphID.toString(), file == null ? "null" : file.getAbsolutePath()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBackup(MaltegoBackupWriter.BackupInterrupt interrupt) throws IOException {
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)"Updating graph backup");
        handle.start();
        try {
            File graphBackupDir = GraphStoreCache.get((GraphID)this.graphID);
            new MtgxSerializer().updateBackup(this.graphID, new MaltegoBackupWriter(graphBackupDir, this.fileType.getMtzVersion(), interrupt), handle);
            this.metadata.updateBackup();
        }
        finally {
            handle.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverGraph(File file) throws IOException {
        MaltegoRecoveryWriter writer = null;
        try {
            writer = MaltegoRecoveryWriter.createRecoveryWriter((File)file);
            this.traverseFiles(writer, GraphStoreCache.get((GraphID)this.graphID), "", 0);
            LOG.log(Level.INFO, "Graph recovered - {0} - {1}", new Object[]{this.graphID.toString(), file.getAbsolutePath()});
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void traverseFiles(MaltegoRecoveryWriter writer, File file, String base, int level) {
        File[] listFiles;
        for (File f : listFiles = file.listFiles()) {
            String relativePath = base == null || base.isEmpty() ? f.getName() : base + "/" + f.getName();
            LOG.log(Level.INFO, "File to recover - {0}", new Object[]{relativePath});
            if (f.isFile()) {
                try {
                    writer.write((Entry)new BackupFileEntry(f, base, f.getName()));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (!f.isDirectory()) continue;
            this.traverseFiles(writer, f, relativePath, level + 1);
        }
    }
}

