/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.recovery.ui.options;

import com.maltego.recovery.ui.BackupPreferences;
import com.paterva.maltego.util.ui.options.OptionsSubPanel;
import com.paterva.maltego.util.ui.options.files.FilesSubPanelFactory;
import java.awt.Container;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RecoveryOptionsPanel
extends OptionsSubPanel {
    private JCheckBox enableRecoveryCheckBox;
    private JTextArea textArea;

    public RecoveryOptionsPanel() {
        this.initComponents();
    }

    public String getTitle() {
        return NbBundle.getMessage(RecoveryOptionsPanel.class, (String)"RecoveryOptionsPanel.title");
    }

    public void update() {
        boolean recoveryEnabled = BackupPreferences.getInstance().isRecoveryEnabled();
        this.enableRecoveryCheckBox.setSelected(recoveryEnabled);
    }

    public void applyChange() {
        BackupPreferences.getInstance().setRecoveryEnabled(this.enableRecoveryCheckBox.isSelected());
    }

    public void setChangeListener(OptionsSubPanel.SettingChangeListener listener) {
        this.enableRecoveryCheckBox.addActionListener(e -> listener.settingChanged());
    }

    private void initComponents() {
        this.textArea = new JTextArea();
        this.enableRecoveryCheckBox = new JCheckBox();
        this.textArea.setEditable(false);
        this.textArea.setBackground(UIManager.getLookAndFeelDefaults().getColor("Panel.background"));
        this.textArea.setColumns(20);
        this.textArea.setLineWrap(true);
        this.textArea.setText(NbBundle.getMessage(RecoveryOptionsPanel.class, (String)"RecoveryOptionsPanel.textArea.text"));
        this.textArea.setWrapStyleWord(true);
        this.textArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Mnemonics.setLocalizedText((AbstractButton)this.enableRecoveryCheckBox, (String)NbBundle.getMessage(RecoveryOptionsPanel.class, (String)"RecoveryOptionsPanel.enableRecoveryCheckBox.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.enableRecoveryCheckBox).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.textArea)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.textArea, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enableRecoveryCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public static class Provider
    implements FilesSubPanelFactory {
        public RecoveryOptionsPanel create() {
            return new RecoveryOptionsPanel();
        }
    }
}

