/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.chat.box;

import com.paterva.maltego.chat.box.InputListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import org.openide.util.NbBundle;

public class ChatInputPanel
extends JPanel {
    private List<InputListener> _listeners = new ArrayList<InputListener>();
    private Timer _timer = new Timer(30, new TransitTimerListener());
    private int _transitProgress = 0;
    private int _fade = 0;
    private boolean _inProgress = false;
    private String _backupText;
    private JTextField _chatTextField;

    public ChatInputPanel() {
        this.initComponents();
        this._chatTextField.setOpaque(false);
        this._chatTextField.addActionListener(new ChatTextFieldListener());
        this._timer.setRepeats(true);
    }

    public void backupText() {
        this._backupText = this._chatTextField.getText();
    }

    public void restoreText() {
        this._chatTextField.setText(this._backupText);
    }

    public void setText(String text) {
        this._chatTextField.setText(text);
    }

    public void addCharacter(char c) {
        if (this._chatTextField.isEnabled()) {
            this._chatTextField.setText(this._chatTextField.getText() + c);
        }
    }

    public void setChatEnabled(boolean enabled) {
        if (enabled != this._chatTextField.isEditable()) {
            this._chatTextField.setEditable(enabled);
            this._chatTextField.setEnabled(enabled);
        }
    }

    public boolean isChatEnabled() {
        return this._chatTextField.isEditable();
    }

    public void setMessagesInTransit(int count) {
        if (count > 0) {
            this._inProgress = true;
            if (!this._timer.isRunning()) {
                this._fade = 0;
                this._transitProgress = 0;
                this._timer.start();
            }
        } else {
            this._inProgress = false;
        }
    }

    public void addChatListener(InputListener listener) {
        this._listeners.add(listener);
    }

    public void removeChatListener(InputListener listener) {
        this._listeners.remove(listener);
    }

    private void fireChatMessage(String message) {
        for (InputListener chatListener : this._listeners) {
            chatListener.inputMessage(message);
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        return this._chatTextField.requestFocusInWindow();
    }

    private void initComponents() {
        this._chatTextField = new TransmitStatusTextField();
        this.setBackground(new Color(232, 233, 250));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this._chatTextField.setText(NbBundle.getMessage(ChatInputPanel.class, (String)"ChatInputPanel._chatTextField.text"));
        this.add((Component)this._chatTextField, "Center");
    }

    private int fade(int colorValue) {
        return colorValue + (255 - colorValue) * this._fade / 100;
    }

    private class TransitTimerListener
    implements ActionListener {
        private static final int FADE_SPEED = 3;

        private TransitTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ChatInputPanel.this._transitProgress = ChatInputPanel.this._transitProgress + 2;
            if (!ChatInputPanel.this._inProgress) {
                ChatInputPanel.this._fade = ChatInputPanel.this._fade + 3;
                if (ChatInputPanel.this._fade > 100) {
                    ChatInputPanel.this._fade = 100;
                    ChatInputPanel.this._timer.stop();
                }
            } else {
                ChatInputPanel.this._fade = ChatInputPanel.this._fade - 3;
                if (ChatInputPanel.this._fade < 0) {
                    ChatInputPanel.this._fade = 0;
                }
            }
            ChatInputPanel.this._chatTextField.repaint();
        }
    }

    private class TransmitStatusTextField
    extends JTextField {
        private TransmitStatusTextField() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (ChatInputPanel.this._timer.isRunning()) {
                Graphics2D g2D = (Graphics2D)g;
                int width = this.getWidth();
                int progressRadius = width / 5;
                int midPercent = Math.abs(ChatInputPanel.this._transitProgress % 200 - 100);
                int mid = midPercent * width / 100;
                int position1 = mid - progressRadius;
                int position2 = mid + progressRadius;
                Point2D.Float start = new Point2D.Float(position1, 0.0f);
                Point2D.Float end = new Point2D.Float(position2, 0.0f);
                float[] dist = new float[]{0.0f, 0.5f, 1.0f};
                Color midColor = new Color(ChatInputPanel.this.fade(170), ChatInputPanel.this.fade(185), ChatInputPanel.this.fade(200));
                Color[] colors = new Color[]{Color.WHITE, midColor, Color.WHITE};
                LinearGradientPaint p = new LinearGradientPaint(start, end, dist, colors);
                g2D.setPaint(p);
                g2D.fillRect(0, 0, width, this.getHeight());
            } else {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            super.paintComponent(g);
        }
    }

    private class ChatTextFieldListener
    implements ActionListener {
        private ChatTextFieldListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ChatInputPanel.this.fireChatMessage(ChatInputPanel.this._chatTextField.getText());
            ChatInputPanel.this._chatTextField.setText("");
        }
    }
}

